/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import javax.security.auth.callback.CallbackHandler;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.elytron.ElytronAccount;
import org.keycloak.adapters.elytron.ElytronHttpFacade;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.Scope;

public class ElytronRequestAuthenticator
extends RequestAuthenticator {
    public ElytronRequestAuthenticator(CallbackHandler callbackHandler, ElytronHttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort) {
        super((HttpFacade)facade, deployment, facade.getTokenStore(), sslRedirectPort);
    }

    public AuthOutcome authenticate() {
        AuthOutcome authenticate = super.authenticate();
        if (AuthOutcome.AUTHENTICATED.equals((Object)authenticate) && !this.getElytronHttpFacade().isAuthorized()) {
            return AuthOutcome.FAILED;
        }
        return authenticate;
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator((RequestAuthenticator)this, this.facade, this.deployment, this.sslRedirectPort, (AdapterSessionStore)this.tokenStore);
    }

    protected void completeOAuthAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        this.getElytronHttpFacade().authenticationComplete(new ElytronAccount(principal), true);
    }

    protected void completeBearerAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal, String method) {
        this.getElytronHttpFacade().authenticationComplete(new ElytronAccount(principal), false);
    }

    protected String changeHttpSessionId(boolean create) {
        HttpScope session = this.getElytronHttpFacade().getScope(Scope.SESSION);
        if (create && !session.exists()) {
            session.create();
        }
        return session != null ? session.getID() : null;
    }

    private ElytronHttpFacade getElytronHttpFacade() {
        return (ElytronHttpFacade)this.facade;
    }
}

