/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.Set;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class KeycloakSecurityRealm
implements SecurityRealm {
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        if (principal instanceof KeycloakPrincipal) {
            return this.createRealmIdentity((KeycloakPrincipal)principal);
        }
        return RealmIdentity.NON_EXISTENT;
    }

    private RealmIdentity createRealmIdentity(final KeycloakPrincipal principal) {
        return new RealmIdentity(){

            public Principal getRealmIdentityPrincipal() {
                return principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.SUPPORTED;
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return principal != null;
            }

            public boolean exists() throws RealmUnavailableException {
                return principal != null;
            }

            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
                MapAttributes attributes = new MapAttributes();
                Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
                attributes.addAll("Roles", (Collection)roles);
                return AuthorizationIdentity.basicIdentity((Attributes)attributes);
            }
        };
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return SupportLevel.POSSIBLY_SUPPORTED;
    }
}

