/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.ServiceName;

public final class Elytron {
    private static final String DEFAULT_SECURITY_DOMAIN = "other";
    private static final String UNDERTOW_APPLICATION_SECURITY_DOMAIN = "org.wildfly.undertow.application-security-domain.";

    static boolean isElytronEnabled(DeploymentPhaseContext phaseContext) {
        String securityDomain = Elytron.getSecurityDomain(phaseContext.getDeploymentUnit());
        ServiceName serviceName = ServiceName.parse((String)(UNDERTOW_APPLICATION_SECURITY_DOMAIN + securityDomain));
        return phaseContext.getServiceRegistry().getService(serviceName) != null;
    }

    private static String getSecurityDomain(DeploymentUnit deploymentUnit) {
        String configuredSecurityDomain;
        JBossWebMetaData webMetaData;
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData != null && (webMetaData = warMetaData.getMergedJBossWebMetaData()) != null && (configuredSecurityDomain = webMetaData.getSecurityDomain()) != null) {
            return configuredSecurityDomain;
        }
        return DEFAULT_SECURITY_DOMAIN;
    }
}

