/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationAddHandler;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationDefinition;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationRemoveHandler;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationWriteAttributeHandler;
import org.keycloak.subsystem.adapter.extension.KeycloakHttpAuthenticationFactoryService;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

final class SecureDeploymentDefinition
extends AbstractAdapterConfigurationDefinition {
    static final String TAG_NAME = "secure-deployment";

    public SecureDeploymentDefinition() {
        super(TAG_NAME, ALL_ATTRIBUTES, new SecureDeploymentAddHandler(), new SecureDeploymentRemoveHandler(), new SecureDeploymentWriteAttributeHandler());
    }

    static final class SecureDeploymentAddHandler
    extends AbstractAdapterConfigurationAddHandler {
        static final String HTTP_SERVER_AUTHENTICATION_CAPABILITY = "org.wildfly.security.http-server-mechanism-factory";
        static RuntimeCapability<Void> HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY;

        SecureDeploymentAddHandler() {
            super(HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY, AbstractAdapterConfigurationDefinition.ALL_ATTRIBUTES);
        }

        @Override
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            if (HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY != null) {
                SecureDeploymentAddHandler.installCapability(context, operation);
            }
        }

        static void installCapability(OperationContext context, ModelNode operation) {
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String factoryName = pathAddress.getLastElement().getValue();
            ServiceName serviceName = context.getCapabilityServiceName(HTTP_SERVER_AUTHENTICATION_CAPABILITY, factoryName, HttpServerAuthenticationMechanismFactory.class);
            KeycloakHttpAuthenticationFactoryService service = new KeycloakHttpAuthenticationFactoryService(factoryName);
            ServiceTarget serviceTarget = context.getServiceTarget();
            serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        static {
            try {
                HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)HTTP_SERVER_AUTHENTICATION_CAPABILITY, (boolean)true, HttpServerAuthenticationMechanismFactory.class).build();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    static final class SecureDeploymentRemoveHandler
    extends AbstractAdapterConfigurationRemoveHandler {
        SecureDeploymentRemoveHandler() {
        }
    }

    static final class SecureDeploymentWriteAttributeHandler
    extends AbstractAdapterConfigurationWriteAttributeHandler {
        SecureDeploymentWriteAttributeHandler() {
            super(AbstractAdapterConfigurationDefinition.ALL_ATTRIBUTES);
        }
    }
}

