/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import java.util.ArrayList;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.keycloak.adapters.elytron.KeycloakConfigurationServletListener;
import org.keycloak.subsystem.adapter.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.adapter.logging.KeycloakLogger;

public class KeycloakAdapterConfigDeploymentProcessor
implements DeploymentUnitProcessor {
    protected Logger log = Logger.getLogger(KeycloakAdapterConfigDeploymentProcessor.class);
    public static final String AUTH_DATA_PARAM_NAME = "org.keycloak.json.adapterConfig";

    protected void addSecurityDomain(DeploymentUnit deploymentUnit, KeycloakAdapterConfigService service) {
        if (!service.isSecureDeployment(deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return;
        }
        LoginConfigMetaData loginConfig = webMetaData.getLoginConfig();
        if (loginConfig == null || !loginConfig.getAuthMethod().equalsIgnoreCase("KEYCLOAK")) {
            return;
        }
        webMetaData.setSecurityDomain("keycloak");
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        KeycloakAdapterConfigService service = KeycloakAdapterConfigService.getInstance();
        if (service.isSecureDeployment(deploymentUnit) && service.isDeploymentConfigured(deploymentUnit)) {
            this.addKeycloakAuthData(phaseContext, service);
        } else if (service.isElytronEnabled(deploymentUnit)) {
            WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
            this.addConfigurationListener(warMetaData);
        }
    }

    private void addKeycloakAuthData(DeploymentPhaseContext phaseContext, KeycloakAdapterConfigService service) throws DeploymentUnitProcessingException {
        LoginConfigMetaData loginConfig;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            throw new DeploymentUnitProcessingException("WarMetaData not found for " + deploymentUnit.getName() + ".  Make sure you have specified a WAR as your secure-deployment in the Keycloak subsystem.");
        }
        this.addJSONData(service.getJSON(deploymentUnit), warMetaData);
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((loginConfig = webMetaData.getLoginConfig()) == null) {
            loginConfig = new LoginConfigMetaData();
            webMetaData.setLoginConfig(loginConfig);
        }
        loginConfig.setAuthMethod("KEYCLOAK");
        loginConfig.setRealmName(service.getRealmName(deploymentUnit));
        KeycloakLogger.ROOT_LOGGER.deploymentSecured(deploymentUnit.getName());
        if (service.isElytronEnabled(deploymentUnit)) {
            this.addConfigurationListener(warMetaData);
        }
    }

    private void addJSONData(String json, WarMetaData warMetaData) {
        ArrayList<ParamValueMetaData> contextParams;
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((contextParams = webMetaData.getContextParams()) == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(AUTH_DATA_PARAM_NAME);
        param.setParamValue(json);
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }

    private void addConfigurationListener(WarMetaData warMetaData) {
        LoginConfigMetaData loginConfig;
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((loginConfig = webMetaData.getLoginConfig()) == null) {
            return;
        }
        if (!loginConfig.getAuthMethod().equals("KEYCLOAK")) {
            return;
        }
        ListenerMetaData listenerMetaData = new ListenerMetaData();
        listenerMetaData.setListenerClass(KeycloakConfigurationServletListener.class.getName());
        webMetaData.getListeners().add(listenerMetaData);
    }

    public void undeploy(DeploymentUnit du) {
    }
}

