/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.keycloak.subsystem.adapter.extension.CredentialDefinition;
import org.keycloak.subsystem.adapter.extension.KeycloakSubsystemDefinition;
import org.keycloak.subsystem.adapter.extension.KeycloakSubsystemParser;
import org.keycloak.subsystem.adapter.extension.RealmDefinition;
import org.keycloak.subsystem.adapter.extension.RedirecRewritetRuleDefinition;
import org.keycloak.subsystem.adapter.extension.SecureDeploymentDefinition;
import org.keycloak.subsystem.adapter.extension.SecureServerDefinition;
import org.keycloak.subsystem.adapter.logging.KeycloakLogger;

public class KeycloakExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "keycloak";
    public static final String NAMESPACE = "urn:jboss:domain:keycloak:1.1";
    private static final KeycloakSubsystemParser PARSER = new KeycloakSubsystemParser();
    static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"keycloak");
    private static final String RESOURCE_NAME = KeycloakExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion MGMT_API_VERSION = ModelVersion.create((int)1, (int)1, (int)0);
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"keycloak");
    private static final ResourceDefinition KEYCLOAK_SUBSYSTEM_RESOURCE = new KeycloakSubsystemDefinition();
    static final RealmDefinition REALM_DEFINITION = new RealmDefinition();
    static final SecureDeploymentDefinition SECURE_DEPLOYMENT_DEFINITION = new SecureDeploymentDefinition();
    static final SecureServerDefinition SECURE_SERVER_DEFINITION = new SecureServerDefinition();
    static final CredentialDefinition CREDENTIAL_DEFINITION = new CredentialDefinition();
    static final RedirecRewritetRuleDefinition REDIRECT_RULE_DEFINITON = new RedirecRewritetRuleDefinition();

    public static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, KeycloakExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)PARSER);
    }

    public void initialize(ExtensionContext context) {
        KeycloakLogger.ROOT_LOGGER.debug("Activating Keycloak Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, MGMT_API_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(KEYCLOAK_SUBSYSTEM_RESOURCE);
        registration.registerSubModel((ResourceDefinition)REALM_DEFINITION);
        ManagementResourceRegistration secureDeploymentRegistration = registration.registerSubModel((ResourceDefinition)SECURE_DEPLOYMENT_DEFINITION);
        secureDeploymentRegistration.registerSubModel((ResourceDefinition)CREDENTIAL_DEFINITION);
        secureDeploymentRegistration.registerSubModel((ResourceDefinition)REDIRECT_RULE_DEFINITON);
        ManagementResourceRegistration secureServerRegistration = registration.registerSubModel((ResourceDefinition)SECURE_SERVER_DEFINITION);
        secureServerRegistration.registerSubModel((ResourceDefinition)CREDENTIAL_DEFINITION);
        secureServerRegistration.registerSubModel((ResourceDefinition)REDIRECT_RULE_DEFINITON);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }
}

