/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.client.RestWorkbenchClient;
import org.kie.wb.test.rest.client.WorkbenchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthServiceIntegrationTest
extends RestTestBase {
    private static Logger log = LoggerFactory.getLogger(HealthServiceIntegrationTest.class);
    private static final String SUCCESS = "success";
    private static WorkbenchClient asyncClient;

    @BeforeClass
    public static void setUp() {
        asyncClient = RestWorkbenchClient.createAsyncWorkbenchClient((String)URL, (String)USER_ID, (String)PASSWORD);
    }

    @Test
    public void testGetReady() {
        String ready = asyncClient.isReady();
        log.info("Readiness status: {}", (Object)ready);
        Assertions.assertThat((String)ready).contains(new CharSequence[]{SUCCESS}).contains(new CharSequence[]{String.valueOf(true)});
    }

    @Test
    public void testGetHealthy() {
        String ready = asyncClient.isHealthy();
        log.info("Healthiness status: {}", (Object)ready);
        Assertions.assertThat((String)ready).contains(new CharSequence[]{SUCCESS}).contains(new CharSequence[]{String.valueOf(true)});
    }
}

