/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.workbench.common.screens.library.api.SpacesScreenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacesScreenServiceIntegrationTest
extends RestTestBase {
    private Logger logger = LoggerFactory.getLogger(SpacesScreenServiceIntegrationTest.class);
    private static final String SPACE_NAME = "ASpace_";
    private String spaceName;

    @BeforeClass
    public static void cleanupSpaces() {
        SpacesScreenServiceIntegrationTest.deleteAllSpaces();
    }

    @Before
    public void before() {
        this.spaceName = SPACE_NAME + SpacesScreenServiceIntegrationTest.getRandomString();
        try {
            Collection spaces = client.getSpaces();
            spaces.forEach(space -> client.deleteSpace(space.getName()));
        }
        catch (Exception ex) {
            this.logger.error("Error ignored", (Throwable)ex);
        }
    }

    @After
    public void after() {
        try {
            Collection spaces = client.getSpaces();
            spaces.forEach(space -> client.deleteSpace(space.getName()));
        }
        catch (Exception ex) {
            this.logger.error("Error ignored", (Throwable)ex);
        }
    }

    @Test
    public void testGetSpaces() {
        Assert.assertEquals((long)0L, (long)this.getSpaces().size());
        SpacesScreenServiceIntegrationTest.createSpace(this.spaceName);
        Assert.assertEquals((long)1L, (long)this.getSpaces().size());
    }

    @Test
    public void testGetSpace() {
        SpacesScreenServiceIntegrationTest.createSpace(this.spaceName);
        Assert.assertEquals((long)200L, (long)client.spacesScreen_getSpace(this.spaceName).getStatus());
    }

    @Test
    public void testValidGroupId() {
        Assert.assertTrue((boolean)client.spacesScreen_isValidGroupId("foo.bar"));
    }

    @Test
    public void testPostSpace() {
        SpacesScreenService.NewSpace newSpace = new SpacesScreenService.NewSpace();
        newSpace.groupId = "foo.bar";
        newSpace.name = SPACE_NAME;
        Assert.assertEquals((long)201L, (long)client.spacesScreen_postSpace(newSpace).getStatus());
    }

    private List<LinkedHashMap<String, Object>> getSpaces() {
        List spaces = (List)client.spacesScreen_getSpaces().readEntity(List.class);
        spaces.removeIf(o -> {
            LinkedHashMap space = (LinkedHashMap)o;
            return (Boolean)space.get("deleted");
        });
        return spaces;
    }
}

