/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.info;

import java.lang.reflect.Field;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.util.Base64;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;

@Entity
@Indexed
public class EntityHolder {
    @Id
    @DocumentId
    @org.hibernate.search.annotations.Field
    private String key;
    @org.hibernate.search.annotations.Field
    private String type;
    @org.hibernate.search.annotations.Field
    private Integer sessionInfoId;
    @org.hibernate.search.annotations.Field
    private Integer sessionInfoVersion;
    @org.hibernate.search.annotations.Field
    private String sessionInfoData;
    @org.hibernate.search.annotations.Field
    private Date sessionInfoLastModificationDate;
    @org.hibernate.search.annotations.Field
    private Date sessionInfoStartDate;
    @org.hibernate.search.annotations.Field
    private Long workItemInfoId;
    @org.hibernate.search.annotations.Field
    private String workItemInfoName;
    @org.hibernate.search.annotations.Field
    private Integer workItemInfoVersion;
    @org.hibernate.search.annotations.Field
    private Long workItemInfoProcessInstanceId;
    @org.hibernate.search.annotations.Field
    private Long workItemInfoState;
    @org.hibernate.search.annotations.Field
    private Date workItemInfoCreationDate;
    @org.hibernate.search.annotations.Field
    private String workItemInfoByteArray;

    public EntityHolder(String key, SessionInfo sessionInfo) {
        this.key = key;
        this.type = "sessionInfo";
        this.sessionInfoId = sessionInfo.getId();
        this.sessionInfoVersion = sessionInfo.getVersion();
        sessionInfo.transform();
        this.sessionInfoData = Base64.encodeBase64String(sessionInfo.getData());
        this.sessionInfoLastModificationDate = sessionInfo.getLastModificationDate();
        this.sessionInfoStartDate = sessionInfo.getStartDate();
    }

    public EntityHolder(String key, WorkItemInfo workItemInfo) {
        this.key = key;
        this.type = "workItemInfo";
        workItemInfo.transform();
        this.workItemInfoId = workItemInfo.getId();
        this.workItemInfoName = workItemInfo.getName();
        this.workItemInfoVersion = workItemInfo.getVersion();
        this.workItemInfoProcessInstanceId = workItemInfo.getProcessInstanceId();
        this.workItemInfoState = workItemInfo.getState();
        this.workItemInfoCreationDate = workItemInfo.getCreationDate();
        this.workItemInfoByteArray = Base64.encodeBase64String(workItemInfo.getWorkItemByteArray());
    }

    protected EntityHolder(String key, String type) {
        this.key = key;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public SessionInfo getSessionInfo() {
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setId(this.sessionInfoId);
        sessionInfo.setData(Base64.decodeBase64(this.sessionInfoData));
        sessionInfo.setLastModificationDate(this.sessionInfoLastModificationDate);
        try {
            Field versionField = SessionInfo.class.getField("version");
            versionField.setAccessible(true);
            versionField.set(sessionInfo, this.sessionInfoVersion);
            Field startDateField = SessionInfo.class.getField("startDate");
            startDateField.setAccessible(true);
            startDateField.set(sessionInfo, this.sessionInfoStartDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sessionInfo;
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfoId = sessionInfo.getId();
        this.sessionInfoVersion = sessionInfo.getVersion();
        sessionInfo.transform();
        this.sessionInfoData = Base64.encodeBase64String(sessionInfo.getData());
        this.sessionInfoLastModificationDate = sessionInfo.getLastModificationDate();
        this.sessionInfoStartDate = sessionInfo.getStartDate();
    }

    public WorkItemInfo getWorkItemInfo() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName(this.workItemInfoName);
        workItem.setProcessInstanceId(this.workItemInfoProcessInstanceId.longValue());
        WorkItemInfo workItemInfo = new WorkItemInfo((WorkItem)workItem, null);
        workItemInfo.setId(this.workItemInfoId);
        try {
            Field versionField = WorkItemInfo.class.getField("version");
            versionField.setAccessible(true);
            versionField.set(workItemInfo, this.workItemInfoVersion);
            Field stateField = WorkItemInfo.class.getField("state");
            stateField.setAccessible(true);
            stateField.set(workItemInfo, this.workItemInfoState);
            Field creationDateField = WorkItemInfo.class.getField("creationDate");
            creationDateField.setAccessible(true);
            creationDateField.set(workItemInfo, this.workItemInfoCreationDate);
            Field workItemByteArrayField = WorkItemInfo.class.getField("workItemByteArray");
            workItemByteArrayField.setAccessible(true);
            workItemByteArrayField.set(workItemInfo, Base64.decodeBase64(this.workItemInfoByteArray));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return workItemInfo;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setWorkItemInfo(WorkItemInfo workItemInfo) {
        workItemInfo.transform();
        this.workItemInfoId = workItemInfo.getId();
        this.workItemInfoName = workItemInfo.getName();
        this.workItemInfoVersion = workItemInfo.getVersion();
        this.workItemInfoProcessInstanceId = workItemInfo.getProcessInstanceId();
        this.workItemInfoState = workItemInfo.getState();
        this.workItemInfoCreationDate = workItemInfo.getCreationDate();
        this.workItemInfoByteArray = Base64.encodeBase64String(workItemInfo.getWorkItemByteArray());
    }
}

