/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.infinispan.processinstance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.jpa.processinstance.JPAWorkItemManager;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class InfinispanWorkItemManager
extends JPAWorkItemManager
implements org.drools.core.process.instance.WorkItemManager {
    private InternalKnowledgeRuntime kruntime;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();

    public InfinispanWorkItemManager(InternalKnowledgeRuntime kruntime) {
        super(kruntime);
        this.kruntime = kruntime;
    }

    public void internalExecuteWorkItem(org.drools.core.process.instance.WorkItem workItem) {
        Environment env = this.kruntime.getEnvironment();
        WorkItemInfo workItemInfo = new WorkItemInfo(workItem, env);
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.api.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        context.persist(workItemInfo);
        ((WorkItemImpl)workItem).setId(workItemInfo.getId().longValue());
        workItemInfo.transform();
        context.merge(workItemInfo);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler != null) {
            handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)this);
            workItemInfo.transform();
            context.merge(workItemInfo);
        } else {
            this.throwWorkItemNotFoundException(workItem);
        }
    }

    private void throwWorkItemNotFoundException(org.drools.core.process.instance.WorkItem workItem) {
        throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
    }

    public WorkItemHandler getWorkItemHandler(String name) {
        return this.workItemHandlers.get(name);
    }

    public void retryWorkItem(long workItemId) {
        org.drools.core.process.instance.WorkItem workItem = this.getWorkItem(workItemId);
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)this);
            } else {
                this.throwWorkItemNotFoundException(workItem);
            }
        }
    }

    public void internalAbortWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.api.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        WorkItemInfo workItemInfo = context.findWorkItemInfo(Long.valueOf(id));
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)this.internalGetWorkItem(workItemInfo);
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.abortWorkItem((WorkItem)workItem, (WorkItemManager)this);
            } else {
                this.throwWorkItemNotFoundException((org.drools.core.process.instance.WorkItem)workItem);
            }
            context.remove(workItemInfo);
        }
    }

    public void internalAddWorkItem(org.drools.core.process.instance.WorkItem workItem) {
    }

    public void completeWorkItem(long id, Map<String, Object> results) {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.api.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        WorkItemInfo workItemInfo = context.findWorkItemInfo(Long.valueOf(id));
        if (workItemInfo != null) {
            org.drools.core.process.instance.WorkItem workItem = this.internalGetWorkItem(workItemInfo);
            workItem.setResults(results);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
            context.remove(workItemInfo);
        }
    }

    public void abortWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.api.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        WorkItemInfo workItemInfo = context.findWorkItemInfo(Long.valueOf(id));
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)this.internalGetWorkItem(workItemInfo);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            context.remove(workItemInfo);
        }
    }

    public org.drools.core.process.instance.WorkItem getWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.api.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        WorkItemInfo workItemInfo = null;
        if (context != null) {
            workItemInfo = context.findWorkItemInfo(Long.valueOf(id));
        }
        if (workItemInfo == null) {
            return null;
        }
        return this.internalGetWorkItem(workItemInfo);
    }

    private org.drools.core.process.instance.WorkItem internalGetWorkItem(WorkItemInfo workItemInfo) {
        Environment env = this.kruntime.getEnvironment();
        InternalKnowledgeBase ruleBase = (InternalKnowledgeBase)this.kruntime.getKieBase();
        org.drools.core.process.instance.WorkItem workItem = workItemInfo.getWorkItem(env, ruleBase);
        ((WorkItemImpl)workItem).setId(workItemInfo.getId().longValue());
        return workItem;
    }

    public Set<org.drools.core.process.instance.WorkItem> getWorkItems() {
        return new HashSet<org.drools.core.process.instance.WorkItem>();
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        super.registerWorkItemHandler(workItemName, handler);
        this.workItemHandlers.put(workItemName, handler);
    }

    public void clearWorkItems() {
    }

    public void clear() {
        this.clearWorkItems();
    }
}

