/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.infinispan;

import org.drools.persistence.api.PersistenceContext;
import org.drools.persistence.api.PersistenceContextManager;
import org.drools.persistence.infinispan.InfinispanPersistenceContext;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.kie.api.runtime.Environment;

public class InfinispanPersistenceContextManager
implements PersistenceContextManager {
    Environment env;
    private DefaultCacheManager cm;
    private Cache<String, Object> appScopedCache;
    protected Cache<String, Object> cmdScopedCache;
    private boolean internalAppScopedCache;
    private boolean internalCmdScopedCache;

    public InfinispanPersistenceContextManager(Environment env) {
        this.env = env;
        this.cm = (DefaultCacheManager)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    public PersistenceContext getApplicationScopedPersistenceContext() {
        if (this.appScopedCache == null) {
            this.appScopedCache = (Cache)this.env.get("org.kie.api.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedCache == null) {
                this.internalAppScopedCache = true;
                this.appScopedCache = this.cm.getCache("jbpm-configured-cache");
                this.env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", this.appScopedCache);
            } else {
                this.internalAppScopedCache = false;
            }
        }
        return new InfinispanPersistenceContext(this.appScopedCache);
    }

    public PersistenceContext getCommandScopedPersistenceContext() {
        return new InfinispanPersistenceContext(this.cmdScopedCache);
    }

    public void beginCommandScopedEntityManager() {
        Cache<String, Object> cmdScopedCache = (Cache<String, Object>)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
        if (cmdScopedCache == null) {
            this.internalCmdScopedCache = true;
            this.cmdScopedCache = this.cm.getCache("jbpm-configured-cache");
            this.env.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", this.cmdScopedCache);
            cmdScopedCache = this.cmdScopedCache;
        } else {
            this.internalCmdScopedCache = false;
        }
    }

    public void endCommandScopedEntityManager() {
        if (this.internalCmdScopedCache) {
            this.env.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", null);
        }
    }

    public void dispose() {
        if (this.internalAppScopedCache) {
            this.internalAppScopedCache = false;
            this.env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", null);
            this.appScopedCache = null;
        }
        if (this.internalCmdScopedCache) {
            this.internalCmdScopedCache = false;
            this.env.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", null);
            this.cmdScopedCache = null;
        }
    }

    public void clearPersistenceContext() {
    }
}

