/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.model;

import java.io.Serializable;
import java.util.Objects;

public class FRI
implements Serializable {
    public static final String SLASH = "/";
    private static final long serialVersionUID = 8729837870805955341L;
    private final String basePath;
    private final String model;
    private final String fri;

    private FRI() {
        this(null, null);
    }

    public FRI(String basePath, String model) {
        this.basePath = FRI.generateBasePath(basePath, model);
        this.model = model;
        this.fri = FRI.generateFri(basePath, model);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getModel() {
        return this.model;
    }

    public String getFri() {
        return this.fri;
    }

    public String toString() {
        return "FRI{basePath='" + this.basePath + '\'' + ", model='" + this.model + '\'' + ", fri='" + this.fri + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FRI fri1 = (FRI)o;
        return Objects.equals(this.fri, fri1.fri);
    }

    public int hashCode() {
        return Objects.hash(this.fri);
    }

    static String generateBasePath(String basePath, String model) {
        if (basePath == null) {
            return null;
        }
        String toReturn = basePath;
        String modelPrefix = SLASH + model + SLASH;
        if (!toReturn.startsWith(SLASH)) {
            toReturn = SLASH + toReturn;
        }
        if (toReturn.startsWith(modelPrefix)) {
            toReturn = toReturn.substring(modelPrefix.length() - 1);
        }
        return toReturn;
    }

    static String generateFri(String basePath, String model) {
        if (basePath == null) {
            return null;
        }
        if (basePath.startsWith(SLASH + model + SLASH)) {
            return basePath;
        }
        String toReturn = basePath;
        if (toReturn.startsWith(SLASH)) {
            toReturn = toReturn.substring(1);
        }
        toReturn = SLASH + model + SLASH + toReturn;
        return toReturn;
    }
}

