/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.io.MemoryFile;
import org.kie.efesto.common.api.utils.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)FileUtils.class.getName());
    private static final String TO_RETURN_TEMPLATE = "toReturn {}";
    private static final String TO_RETURN_GETABSOLUTEPATH_TEMPLATE = "toReturn.getAbsolutePath() {}";

    private FileUtils() {
    }

    public static File getFile(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        File toReturn = ResourceHelper.getResourcesByExtension(extension).filter(file -> file.getName().equals(fileName)).findFirst().orElse(null);
        if (toReturn == null) {
            throw new KieEfestoCommonException(String.format("Failed to find %s due to", fileName));
        }
        return toReturn;
    }

    public static FileInputStream getFileInputStream(String fileName) throws IOException {
        File sourceFile = FileUtils.getFile(fileName);
        return new FileInputStream(sourceFile);
    }

    public static String getFileContent(String fileName) throws IOException {
        File file = FileUtils.getFile(fileName);
        Path path = file.toPath();
        Stream<String> lines = Files.lines(path);
        String toReturn = lines.collect(Collectors.joining("\n"));
        lines.close();
        return toReturn;
    }

    public static InputStream getInputStreamFromFileName(String fileName) {
        try {
            InputStream toReturn = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (toReturn == null) {
                throw new KieEfestoCommonException(String.format("Failed to find %s", fileName));
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to find %s due to %s", fileName, e.getMessage()), e);
        }
    }

    public static Optional<File> getFileFromFileNameOrFilePath(String fileName, String filePath) {
        Optional<File> fromClassloader = FileUtils.getFileByFileNameFromClassloader(fileName, Thread.currentThread().getContextClassLoader());
        return fromClassloader.isPresent() ? fromClassloader : FileUtils.getFileByFilePath(filePath);
    }

    public static Optional<File> getFileFromFileName(String fileName) {
        logger.debug("getFileFromFileName {}", (Object)fileName);
        return FileUtils.getFileByFileNameFromClassloader(fileName, Thread.currentThread().getContextClassLoader());
    }

    public static Optional<File> getFileByFileNameFromClassloader(String fileName, ClassLoader classLoader) {
        logger.debug("getFileByFileNameFromClassloader {} {}", (Object)fileName, (Object)classLoader);
        URL retrieved = classLoader.getResource(fileName);
        if (retrieved != null) {
            logger.debug("retrieved {}", (Object)retrieved);
            return FileUtils.getFileFromURL(retrieved);
        }
        File file = new File(fileName);
        logger.debug("file {}", (Object)file);
        logger.debug("file.exists() {}", (Object)file.exists());
        return file.exists() ? Optional.of(file) : Optional.empty();
    }

    public static Optional<File> getFileByFilePath(String filePath) {
        File file = new File(filePath);
        return file.exists() ? Optional.of(file) : Optional.empty();
    }

    static Optional<File> getFileFromURL(URL retrieved) {
        logger.debug("getFileFromURL {}", (Object)retrieved);
        logger.debug("retrieved.getProtocol() {}", (Object)retrieved.getProtocol());
        if (logger.isDebugEnabled()) {
            FileUtils.debugURLContent(retrieved);
        }
        logger.debug("retrieved.getPath() {}", (Object)retrieved.getPath());
        switch (retrieved.getProtocol()) {
            case "jar": {
                return FileUtils.getOptionalFileFromJar(retrieved);
            }
            case "resource": {
                return FileUtils.getOptionalFileFromResource(retrieved);
            }
        }
        return FileUtils.getOptionalFileFromURLFile(retrieved);
    }

    static Optional<File> getOptionalFileFromJar(URL retrieved) {
        try {
            File toReturn = FileUtils.getFileFromJar(retrieved);
            logger.debug(TO_RETURN_TEMPLATE, (Object)toReturn);
            return Optional.of(toReturn);
        }
        catch (Exception e) {
            throw new KieEfestoCommonException("Failed to read file " + retrieved, e);
        }
    }

    static Optional<File> getOptionalFileFromResource(URL retrieved) {
        try {
            File toReturn = FileUtils.getFileFromResource(retrieved);
            logger.debug(TO_RETURN_TEMPLATE, (Object)toReturn);
            return Optional.of(toReturn);
        }
        catch (Exception e) {
            throw new KieEfestoCommonException("Failed to read file " + retrieved, e);
        }
    }

    static Optional<File> getOptionalFileFromURLFile(URL retrieved) {
        File toReturn = new File(retrieved.getFile());
        logger.debug(TO_RETURN_TEMPLATE, (Object)toReturn);
        logger.debug(TO_RETURN_GETABSOLUTEPATH_TEMPLATE, (Object)toReturn.getAbsolutePath());
        return Optional.of(toReturn);
    }

    static File getFileFromResource(URL retrieved) throws IOException {
        logger.debug("getFileFromResource {}", (Object)retrieved);
        MemoryFile toReturn = new MemoryFile(retrieved);
        logger.debug(TO_RETURN_TEMPLATE, (Object)toReturn);
        logger.debug(TO_RETURN_GETABSOLUTEPATH_TEMPLATE, (Object)toReturn.getAbsolutePath());
        return toReturn;
    }

    static File getFileFromJar(URL retrieved) throws URISyntaxException, IOException {
        Path filePath;
        logger.debug("getFileFromJar {}", (Object)retrieved);
        String fileName = retrieved.getFile();
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf(47));
        }
        String jarPath = retrieved.toString();
        jarPath = jarPath.substring(0, jarPath.lastIndexOf("!/") + 2);
        URI uri = new URI(jarPath);
        HashMap env = new HashMap();
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            filePath = fs.getPath(fileName, new String[0]);
        }
        MemoryFile toReturn = new MemoryFile(filePath);
        logger.debug(TO_RETURN_TEMPLATE, (Object)toReturn);
        logger.debug(TO_RETURN_GETABSOLUTEPATH_TEMPLATE, (Object)toReturn.getAbsolutePath());
        return toReturn;
    }

    static void debugURLContent(URL retrieved) {
        if (retrieved != null) {
            try (InputStream input = retrieved.openStream();){
                int read;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((read = input.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                logger.debug("retrieved.getContent() {}", (Object)out.toByteArray());
                out.flush();
                out.close();
            }
            catch (Exception e) {
                logger.warn("failed to read content for {}", (Object)retrieved);
            }
        }
    }
}

