/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.cache;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EfestoClassKey
implements ParameterizedType {
    private final Type rawType;
    private final Type[] typeArguments;

    public EfestoClassKey(Type rawType, Type ... typeArguments) {
        this.rawType = rawType;
        this.typeArguments = typeArguments;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    public String toString() {
        String argsString = Stream.of(this.typeArguments).map(this::getCanonicalTypeName).collect(Collectors.joining(", "));
        return this.getCanonicalTypeName(this.rawType) + "<" + argsString + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EfestoClassKey that = (EfestoClassKey)o;
        return Objects.equals(this.rawType, that.rawType) && Arrays.equals(this.typeArguments, that.typeArguments);
    }

    public int hashCode() {
        int result = Objects.hash(this.rawType);
        result = 31 * result + Arrays.hashCode(this.typeArguments);
        return result;
    }

    private String getCanonicalTypeName(Type type) {
        return type instanceof Class ? ((Class)type).getCanonicalName() : type.getTypeName();
    }
}

