/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.api.model;

import java.lang.reflect.Type;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.cache.EfestoClassKey;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.runtimemanager.api.model.BaseEfestoInput;

class EfestoInputTest {
    EfestoInputTest() {
    }

    @Test
    void getFirstLevelCacheKeySameParentClass() {
        BaseEfestoInput input = new BaseEfestoInput(null, (Object)"ONE");
        EfestoClassKey expected = new EfestoClassKey(BaseEfestoInput.class, new Type[]{String.class});
        Assertions.assertThat((Object)input.getFirstLevelCacheKey()).isEqualTo((Object)expected);
    }

    @Test
    void getFirstLevelCacheKeyDifferentParentClass() {
        BaseEfestoInputExtender input = new BaseEfestoInputExtender(null, "ONE");
        EfestoClassKey unexpected = new EfestoClassKey(BaseEfestoInput.class, new Type[]{String.class});
        Assertions.assertThat((Object)input.getFirstLevelCacheKey()).isNotEqualTo((Object)unexpected);
    }

    @Test
    void getFirstLevelCacheKeySameChildClass() {
        BaseEfestoInputExtender input = new BaseEfestoInputExtender(null, "ONE");
        EfestoClassKey expected = new EfestoClassKey(BaseEfestoInputExtender.class, new Type[]{String.class});
        Assertions.assertThat((Object)input.getFirstLevelCacheKey()).isEqualTo((Object)expected);
    }

    @Test
    void getFirstLevelCacheKeyDifferentChildClass() {
        BaseEfestoInput input = new BaseEfestoInput(null, (Object)"ONE");
        EfestoClassKey unexpected = new EfestoClassKey(BaseEfestoInputExtender.class, new Type[]{String.class});
        Assertions.assertThat((Object)input.getFirstLevelCacheKey()).isNotEqualTo((Object)unexpected);
    }

    static class BaseEfestoInputExtender
    extends BaseEfestoInput<String> {
        public BaseEfestoInputExtender(ModelLocalUriId modelLocalUriId, String inputData) {
            super(modelLocalUriId, (Object)inputData);
        }
    }
}

