/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven;

import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.kie.integration.eap.maven.eap.EAPFileSystemBaseModulesScanner;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;

public class EAPBaseModulesDescriptorGenerationMojo
extends AbstractMojo {
    private MavenProject project;
    private RepositorySystem repoSystem;
    protected ProjectDependenciesResolver projectDependenciesResolver;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;
    private String eapRootPath;
    private String outputFilePath;
    private String tempPath;
    private String eapName;
    private String mavenModulesVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.eapRootPath == null || this.eapRootPath.trim().length() == 0) {
            throw new MojoFailureException("EAP root path is not set.");
        }
        if (this.outputFilePath == null || this.outputFilePath.trim().length() == 0) {
            throw new MojoFailureException("Output file path is not set.");
        }
        if (this.eapName == null || this.eapName.trim().length() == 0) {
            throw new MojoFailureException("The resulting distributio JBoss EAP/AS name is not set.");
        }
        if (this.mavenModulesVersion == null || this.mavenModulesVersion.trim().length() == 0) {
            this.getLog().warn((CharSequence)"No mavenModulesVersion goal property set. By default the current project version will be used.");
            this.mavenModulesVersion = this.project.getVersion();
        }
        this.getLog().info((CharSequence)("Starting the generation of base EAP static modules present in path " + this.eapRootPath));
        EAPFileSystemBaseModulesScanner generator = new EAPFileSystemBaseModulesScanner(this.eapRootPath, this.eapName, this.mavenModulesVersion, this.outputFilePath);
        generator.setLogger(this.getLog());
        generator.setTempPath(this.tempPath);
        try {
            generator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating EAP base module descriptors.");
        }
        this.getLog().info((CharSequence)("Base EAP static module descriptor sucessfully generated at " + this.outputFilePath));
    }
}

