/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.model.graph.distribution;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.kie.integration.eap.maven.model.common.PathFilter;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeDependency;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeResource;

public class EAPModuleGraphDistributionNode
implements EAPModuleGraphNode {
    private String name;
    private String location;
    private String slot;
    private List<EAPModuleGraphNodeResource> resources;
    private List<EAPModuleGraphNodeDependency> dependencies;

    public EAPModuleGraphDistributionNode(String name, String location, String slot) {
        this.name = name;
        this.location = location;
        this.slot = slot;
        this.resources = new LinkedList<EAPModuleGraphNodeResource>();
        this.dependencies = new LinkedList<EAPModuleGraphNodeDependency>();
    }

    public boolean addResource(EAPModuleGraphNodeResource resource) {
        return this.resources.add(resource);
    }

    public boolean addDependency(EAPModuleGraphNodeDependency dependency) {
        return this.dependencies.add(dependency);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getSlot() {
        if (this.slot == null || this.slot.trim().length() == 0) {
            return "main";
        }
        return this.slot;
    }

    @Override
    public String getUniqueId() {
        return this.getName() + ":" + this.getSlot();
    }

    @Override
    public List<EAPModuleGraphNodeResource> getResources() {
        return this.resources;
    }

    @Override
    public List<EAPModuleGraphNodeDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Collection<PathFilter> getExports() {
        return null;
    }

    @Override
    public String print() {
        return "";
    }

    public int compareTo(Object o) {
        EAPModuleGraphNode other = (EAPModuleGraphNode)o;
        return this.getName().compareTo(other.getName());
    }
}

