/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.model.graph.flat;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.kie.integration.eap.maven.model.common.PathFilter;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeDependency;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeResource;
import org.kie.integration.eap.maven.model.graph.flat.EAPModuleGraphFlatNodeDependency;
import org.kie.integration.eap.maven.model.graph.flat.EAPModuleGraphFlatNodeResource;
import org.kie.integration.eap.maven.model.graph.flat.EAPModulesFlatGraph;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;

public class EAPModuleGraphFlatNode
implements EAPModuleGraphNode {
    private EAPModule module;
    private List<EAPModuleGraphNodeResource> resources;
    private List<EAPModuleGraphNodeDependency> dependencies;

    public EAPModuleGraphFlatNode(EAPModule module) {
        this.module = module;
        this.init();
    }

    private void init() {
        Collection<EAPModuleResource> resources = this.module.getResources();
        Collection<EAPModuleDependency> dependencies = this.module.getDependencies();
        if (resources != null && !resources.isEmpty()) {
            this.resources = new LinkedList<EAPModuleGraphNodeResource>();
            for (EAPModuleResource resource : resources) {
                this.resources.add(new EAPModuleGraphFlatNodeResource(resource));
            }
        }
        if (dependencies != null && !dependencies.isEmpty()) {
            this.dependencies = new LinkedList<EAPModuleGraphNodeDependency>();
            for (EAPModuleDependency dependency : dependencies) {
                this.dependencies.add(new EAPModuleGraphFlatNodeDependency(dependency));
            }
        }
    }

    @Override
    public String print() {
        return EAPModulesFlatGraph.print(this.module);
    }

    @Override
    public String getName() {
        return this.module.getName();
    }

    @Override
    public String getLocation() {
        return this.module.getLocation();
    }

    @Override
    public String getSlot() {
        return this.module.getSlot();
    }

    @Override
    public String getUniqueId() {
        return this.module.getUniqueId();
    }

    @Override
    public List<EAPModuleGraphNodeResource> getResources() {
        return this.resources;
    }

    @Override
    public List<EAPModuleGraphNodeDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Collection<PathFilter> getExports() {
        return null;
    }

    public int compareTo(Object o) {
        EAPModuleGraphNode other = (EAPModuleGraphNode)o;
        return this.getName().compareTo(other.getName());
    }
}

