/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.model.graph.flat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.kie.integration.eap.maven.model.dependency.EAPBaseModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPCustomModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPModuleMissingDependency;
import org.kie.integration.eap.maven.model.dependency.EAPStaticModuleDependency;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModulesGraph;
import org.kie.integration.eap.maven.model.graph.flat.EAPModuleGraphFlatNode;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPArtifactOptionalResource;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.kie.integration.eap.maven.model.resource.EAPUnresolvableArtifactResource;
import org.kie.integration.eap.maven.model.resource.EAPVersionMismatchedArtifactResource;

public class EAPModulesFlatGraph
implements EAPModulesGraph {
    public static final String DEPENDENCY_SEPARATOR = "-_-";
    private List<EAPModuleGraphNode> nodes;
    private String distributionName;
    private String printedGraph;
    private static int totalResources;
    private static int unresolvableResources;
    private static int totalDependencies;
    private static int staticDependencies;
    private static int missingDependencies;
    private static int missingOptionalDependencies;
    private static int eapDependencies;
    private static int optionalDependencies;
    private static int versionMismatchedResources;

    public EAPModulesFlatGraph(String distributionName, EAPLayer layer) {
        this.distributionName = distributionName;
        Collection<EAPModule> _modules = this.getModulesWithResources(layer.getModules());
        if (_modules != null && !_modules.isEmpty()) {
            this.nodes = new LinkedList<EAPModuleGraphNode>();
            for (EAPModule module : _modules) {
                this.nodes.add(new EAPModuleGraphFlatNode(module));
            }
        }
    }

    @Override
    public List<EAPModuleGraphNode> getNodes() {
        return this.nodes;
    }

    @Override
    public String getDistributionName() {
        return this.distributionName;
    }

    protected Collection<EAPModule> getModulesReferenced(Collection<EAPModule> modules) {
        LinkedList<EAPModule> result = null;
        if (modules != null) {
            HashSet<String> list = new HashSet<String>();
            result = new LinkedList<EAPModule>();
            for (EAPModule module : modules) {
                Collection<EAPModuleDependency> dependencies = module.getDependencies();
                if (dependencies == null) continue;
                for (EAPModuleDependency next : dependencies) {
                    if (next instanceof EAPModuleMissingDependency) continue;
                    list.add(next.getName() + DEPENDENCY_SEPARATOR + next.getSlot());
                }
            }
            for (EAPModule module : modules) {
                String key = module.getName() + DEPENDENCY_SEPARATOR + module.getSlot();
                if (!list.contains(key)) continue;
                result.add(module);
            }
        }
        return result;
    }

    protected Collection<EAPModule> getModulesWithResources(Collection<EAPModule> modules) {
        LinkedList<EAPModule> result = null;
        if (modules != null) {
            result = new LinkedList<EAPModule>();
            for (EAPModule module : modules) {
                Collection<EAPModuleResource> dependencies = module.getResources();
                if (dependencies == null) continue;
                boolean resolvable = false;
                for (EAPModuleResource next : dependencies) {
                    if (next instanceof EAPUnresolvableArtifactResource) continue;
                    resolvable = true;
                }
                if (!resolvable) continue;
                result.add(module);
            }
        }
        return result;
    }

    @Override
    public String print() {
        if (this.printedGraph != null) {
            return this.printedGraph;
        }
        ArrayList<EAPModuleGraphNode> sortedModules = new ArrayList<EAPModuleGraphNode>(this.nodes);
        Collections.sort(sortedModules);
        StringBuilder nodesPrint = new StringBuilder();
        if (this.nodes != null) {
            for (EAPModuleGraphNode node : sortedModules) {
                nodesPrint.append(node.print());
            }
        }
        StringBuilder result = new StringBuilder("\n");
        result.append("********************************************************************************************").append("\n");
        result.append("Dependency graph for " + this.distributionName).append("\n");
        result.append("Graph type: FLAT - No module dependencies are exported (export=false)").append("\n");
        result.append("Total modules: ").append(this.nodes.size()).append("\n");
        result.append("Total resources: ").append(totalResources).append("\n");
        result.append("Total unresolvable resources: ").append(unresolvableResources).append("\n");
        result.append("Total version mismatched resources: ").append(versionMismatchedResources).append("\n");
        result.append("Total dependencies: ").append(totalDependencies).append("\n");
        result.append("Total static dependencies: ").append(staticDependencies).append("\n");
        result.append("Total missing dependencies: ").append(missingDependencies).append("\n");
        result.append("Total missing optional dependencies: ").append(missingOptionalDependencies).append("\n");
        result.append("Total EAP/AS dependencies: ").append(eapDependencies).append("\n");
        result.append("Total optional dependencies: ").append(optionalDependencies).append("\n");
        result.append("********************************************************************************************").append("\n");
        result.append((CharSequence)nodesPrint).append("\n");
        result.append("********************************************************************************************").append("\n");
        this.printedGraph = result.toString();
        return this.printedGraph;
    }

    public static String print(EAPModule module) {
        StringBuilder result = new StringBuilder();
        result.append("+ ").append(module.getUniqueId()).append("\n");
        if (module.getResources() != null && !module.getResources().isEmpty()) {
            ArrayList<EAPModuleResource> sortedResources = new ArrayList<EAPModuleResource>(module.getResources());
            Collections.sort(sortedResources, new ResourceComparator());
            for (EAPModuleResource resource : sortedResources) {
                result.append(EAPModulesFlatGraph.print(resource));
            }
        }
        if (module.getDependencies() != null && !module.getDependencies().isEmpty()) {
            ArrayList<EAPModuleDependency> sortedDependencies = new ArrayList<EAPModuleDependency>(module.getDependencies());
            Collections.sort(sortedDependencies, new DependencyComparator());
            for (EAPModuleDependency dependency : sortedDependencies) {
                result.append(EAPModulesFlatGraph.print(dependency));
            }
        }
        return result.toString();
    }

    public static String print(EAPModuleResource resource) {
        StringBuilder result = new StringBuilder("| +- ");
        result.append(resource.getName());
        if (resource instanceof EAPUnresolvableArtifactResource) {
            result.append(" (UNRESOLVABLE) ");
            ++unresolvableResources;
        }
        if (resource instanceof EAPVersionMismatchedArtifactResource) {
            result.append(" (VERSION MISMATCH from '" + ((EAPVersionMismatchedArtifactResource)resource).getVersion() + "') ");
            ++versionMismatchedResources;
        } else if (resource instanceof EAPArtifactOptionalResource) {
            result.append(" (OPTIONAL) ");
        }
        ++totalResources;
        result.append("\n");
        return result.toString();
    }

    public static String print(EAPModuleDependency dependency) {
        String isExported;
        StringBuilder result = new StringBuilder("| +-> ");
        result.append(dependency.getName()).append(":").append(dependency.getSlot());
        String isOptional = dependency.isOptional() ? ",OPTIONAL" : "";
        String string = isExported = dependency.isExport() ? ",EXPORTED" : "";
        if (dependency instanceof EAPBaseModuleDependency) {
            result.append(" (EAP").append(isExported).append(isOptional).append(")");
            ++eapDependencies;
        } else if (dependency instanceof EAPStaticModuleDependency) {
            result.append(" (STATIC").append(isExported).append(isOptional).append(")");
            ++staticDependencies;
        } else if (dependency instanceof EAPModuleMissingDependency) {
            result.append(" (MISSING").append(isExported).append(isOptional).append(")");
            if (!dependency.isOptional()) {
                ++missingDependencies;
            } else {
                ++missingOptionalDependencies;
            }
        } else if (dependency instanceof EAPCustomModuleDependency) {
            if (dependency.isOptional()) {
                result.append(" (OPTIONAL)");
            }
            if (dependency.isExport()) {
                result.append(" (EXPORTED)");
            }
            ++optionalDependencies;
        }
        ++totalDependencies;
        result.append("\n");
        return result.toString();
    }

    private static class DependencyComparator
    implements Comparator {
        private DependencyComparator() {
        }

        public int compare(Object o1, Object o2) {
            EAPModuleDependency m1 = (EAPModuleDependency)o1;
            EAPModuleDependency m2 = (EAPModuleDependency)o2;
            return m1.getName().compareTo(m2.getName());
        }
    }

    private static class ResourceComparator
    implements Comparator {
        private ResourceComparator() {
        }

        public int compare(Object o1, Object o2) {
            EAPModuleResource m1 = (EAPModuleResource)o1;
            EAPModuleResource m2 = (EAPModuleResource)o2;
            return m1.getName().compareTo(m2.getName());
        }
    }
}

