/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Scanner;

public class EAPFileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream inputStream, FileOutputStream outputStream) throws IOException {
        try {
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeToFile(InputStream inputStream, String fileNem) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(fileNem);
        EAPFileUtils.writeToFile(inputStream, outputStream);
    }

    public static void writeToFile(String str, File f) throws IOException {
        EAPFileUtils.writeToFile((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), f);
    }

    public static void writeToFile(String str, String fileName) throws IOException {
        EAPFileUtils.writeToFile((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), fileName);
    }

    public static void writeToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        EAPFileUtils.writeToFile(inputStream, outputStream);
    }

    public static File writeFile(File path, String fileName, String fileContent) throws IOException {
        if (fileContent != null && fileContent.trim().length() > 0) {
            path.mkdirs();
            File out = new File(path, fileName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(out));
            writer.write(fileContent);
            writer.close();
            return out;
        }
        return null;
    }

    public static void removeFirstLineIfDuplicated(File path) throws IOException {
        Scanner scanner = new Scanner(path);
        ArrayList<String> coll = new ArrayList<String>();
        String firstLine = scanner.nextLine();
        if (scanner.hasNextLine()) {
            String secondLine = scanner.nextLine();
            if (!firstLine.equalsIgnoreCase(secondLine)) {
                coll.add(firstLine);
            }
            coll.add(secondLine);
        }
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            coll.add(line);
        }
        scanner.close();
        FileWriter writer = new FileWriter(path);
        for (String line : coll) {
            writer.write(line);
        }
        writer.close();
    }

    public static String extractFileName(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        int fileNameIndex = path.lastIndexOf(File.separator);
        int fileNameExtIndex = path.lastIndexOf(".");
        return path.substring(fileNameIndex + 1, fileNameExtIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromInputStream(InputStream is) throws Exception {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return sb.toString();
    }
}

