/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.distribution;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.kie.integration.eap.maven.eap.EAPContainer;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeDependency;
import org.kie.integration.eap.maven.model.graph.EAPModulesGraph;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;

public class EAPStaticLayerDistribution {
    private String distributionName;
    private EAPLayer staticLayer;
    private EAPLayer baseLayer;
    private EAPContainer container;
    private EAPArtifactsHolder artifactsHolder;
    private EAPModulesGraph graph;
    private String printedDistro;
    private Boolean includedOptionalDependencies;

    public EAPStaticLayerDistribution(String distributionName, EAPModulesGraph graph, EAPContainer container) {
        this.container = container;
        this.distributionName = distributionName;
        this.graph = graph;
        this.includedOptionalDependencies = null;
    }

    public String print() {
        String unreferencendModules;
        if (this.printedDistro != null) {
            return this.printedDistro;
        }
        StringBuilder result = new StringBuilder("\n");
        result.append("********************************************************************************************").append("\n");
        result.append("Distribution ").append(this.distributionName).append("\n");
        if (this.container != null) {
            result.append("Base EAP: ").append(this.container.toString()).append("\n");
        }
        if (this.baseLayer != null) {
            result.append("Base EAP modules count: ").append(this.baseLayer.getModules().size()).append("\n");
        }
        if (this.staticLayer != null) {
            result.append("Static modues count: ").append(this.staticLayer.getModules().size()).append("\n");
        }
        if (this.baseLayer != null && this.staticLayer != null) {
            result.append("Total modues count: ").append(this.staticLayer.getModules().size() + this.baseLayer.getModules().size()).append("\n");
        }
        if (this.includedOptionalDependencies != null && this.includedOptionalDependencies.booleanValue()) {
            result.append("Scanned optional dependencies included.").append("\n");
        } else if (this.includedOptionalDependencies != null && !this.includedOptionalDependencies.booleanValue()) {
            result.append("Scanned optional dependencies not included.").append("\n");
        }
        result.append("********************************************************************************************").append("\n");
        if (this.graph != null) {
            result.append(this.graph.print());
        }
        if ((unreferencendModules = this.printUnreferencedModules()) != null) {
            result.append(unreferencendModules);
        }
        this.printedDistro = result.toString();
        return this.printedDistro;
    }

    protected String printArtifactResolutionModulesMapping() {
        StringBuilder result = new StringBuilder();
        Map<String, String> mappings = this.artifactsHolder.getMappedCoordinates();
        if (mappings != null && !mappings.isEmpty()) {
            result.append("****************************************************************************************").append("\n");
            result.append("+++++++++++ Artifact resolution perfomed for each module ++++++++++++++++++++").append("\n");
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                String allCords = entry.getKey();
                String shortCords = entry.getValue();
                StringBuilder line = new StringBuilder();
                line.append("'").append(allCords).append("' <-> '").append(shortCords).append("'").append("\n");
                result.append(line.toString());
            }
            result.append("****************************************************************************************").append("\n");
        }
        return result.toString();
    }

    protected Collection<String> getReferencedModuleUIDs() {
        LinkedHashSet<String> result = null;
        List<EAPModuleGraphNode> nodes = this.graph.getNodes();
        if (nodes != null && !nodes.isEmpty()) {
            result = new LinkedHashSet<String>();
            for (EAPModuleGraphNode node : nodes) {
                List<EAPModuleGraphNodeDependency> dependencies = node.getDependencies();
                if (dependencies == null || dependencies.isEmpty()) continue;
                for (EAPModuleGraphNodeDependency dependency : dependencies) {
                    String depModuleUID = EAPArtifactUtils.getUID(dependency.getName(), dependency.getSlot());
                    result.add(depModuleUID);
                }
            }
        }
        return result;
    }

    protected String printUnreferencedModules() {
        StringBuilder result = null;
        Collection<String> referencedModuleUIDs = this.getReferencedModuleUIDs();
        if (referencedModuleUIDs != null && !referencedModuleUIDs.isEmpty()) {
            List<EAPModuleGraphNode> nodes = this.graph.getNodes();
            LinkedHashSet<EAPModuleGraphNode> unreferencedModules = new LinkedHashSet<EAPModuleGraphNode>();
            for (String referencedNodeUID : referencedModuleUIDs) {
                for (EAPModuleGraphNode node : nodes) {
                    String moduleUID = node.getUniqueId();
                    if (referencedModuleUIDs.contains(moduleUID)) continue;
                    unreferencedModules.add(node);
                }
            }
            if (!unreferencedModules.isEmpty()) {
                result = new StringBuilder();
                result.append("****************************************************************************************").append("\n");
                result.append("+++++++++++ Unreferenced modules ++++++++++++++++++++").append("\n");
                for (EAPModuleGraphNode node : unreferencedModules) {
                    result.append(node.getUniqueId()).append("\n");
                }
                result.append("****************************************************************************************").append("\n");
            }
        }
        return result != null ? result.toString() : null;
    }

    public void setStaticLayer(EAPLayer staticLayer) {
        this.staticLayer = staticLayer;
    }

    public void setBaseLayer(EAPLayer baseLayer) {
        this.baseLayer = baseLayer;
    }

    public void setArtifactsHolder(EAPArtifactsHolder artifactsHolder) {
        this.artifactsHolder = artifactsHolder;
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public EAPLayer getStaticLayer() {
        return this.staticLayer;
    }

    public EAPLayer getBaseLayer() {
        return this.baseLayer;
    }

    public EAPModulesGraph getGraph() {
        return this.graph;
    }

    public Boolean getIncludedOptionalDependencies() {
        return this.includedOptionalDependencies;
    }

    public void setIncludedOptionalDependencies(Boolean includedOptionalDependencies) {
        this.includedOptionalDependencies = includedOptionalDependencies;
    }

    public EAPContainer getContainer() {
        return this.container;
    }
}

