/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.model.layer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kie.integration.eap.maven.exception.EAPModulesDefinitionException;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.sonatype.aether.artifact.Artifact;

public class EAPLayerImpl
implements EAPLayer {
    private String name;
    private Properties properties;
    private Map<String, EAPModule> modules;

    public EAPLayerImpl(String name) {
        this.name = name;
        this.properties = new Properties();
        this.modules = new HashMap<String, EAPModule>();
    }

    @Override
    public EAPModule addModule(EAPModule module) throws EAPModulesDefinitionException {
        return this.modules.put(module.getUniqueId(), module);
    }

    @Override
    public EAPModule getModule(String moduleUID) {
        return this.modules.get(moduleUID);
    }

    @Override
    public EAPModule getModule(Artifact artifact) {
        for (EAPModule module : this.modules.values()) {
            if (!EAPArtifactUtils.equals(artifact, module.getArtifact())) continue;
            return module;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Collection<EAPModule> getModules() {
        return this.modules.values();
    }

    public void setModules(Map<String, EAPModule> modules) {
        this.modules = modules;
    }
}

