/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.model.dependency;

import java.util.Collection;
import java.util.HashSet;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.sonatype.aether.artifact.Artifact;

public class EAPCustomModuleDependency
implements EAPModuleDependency {
    private String name;
    private String slot;
    private boolean optional;
    private boolean export;
    private Collection<Artifact> artifacts;

    public EAPCustomModuleDependency(String name) {
        this.name = name;
        this.artifacts = new HashSet<Artifact>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSlot() {
        if (this.slot == null || this.slot.trim().length() == 0) {
            return "main";
        }
        return this.slot;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Collection<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public boolean addArtifact(Artifact artifact) {
        return this.artifacts.add(artifact);
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @Override
    public boolean isExport() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            EAPCustomModuleDependency dep = (EAPCustomModuleDependency)obj;
            return this.name.equalsIgnoreCase(dep.getName()) && this.slot.equalsIgnoreCase(dep.getSlot()) && this.isOptional() == this.isOptional();
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

