/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.eap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class EAPContainer {
    private static final Pattern ID_PARSER_PATTERN = Pattern.compile("(.*)-(.*)");
    private String eapVersionId;
    private EAPContainerId containerId;
    private ComparableVersion version;

    public EAPContainer(String eapVersionId) {
        this.eapVersionId = eapVersionId;
        this.parseId();
    }

    protected void parseId() {
        if (this.eapVersionId == null || this.eapVersionId.trim().length() == 0) {
            throw new IllegalArgumentException("EAP Version is empty or null.");
        }
        Matcher m1 = ID_PARSER_PATTERN.matcher(this.eapVersionId);
        boolean matches = m1.matches();
        if (!matches) {
            throw new IllegalArgumentException("EAP Version '" + this.eapVersionId + "' does not match the pattern.");
        }
        String _containerId = m1.group(1);
        String _version = m1.group(2);
        this.containerId = EAPContainerId.AS.name().equals(_containerId) ? EAPContainerId.AS : EAPContainerId.EAP;
        this.version = new ComparableVersion(_version);
    }

    public EAPContainerId getContainerId() {
        return this.containerId;
    }

    public ComparableVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return this.eapVersionId;
    }

    public static enum EAPContainerId {
        EAP,
        AS;

    }
}

