/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.patch;

import java.util.List;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;
import org.kie.integration.eap.maven.distribution.EAPStaticLayerDistribution;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeResource;
import org.kie.integration.eap.maven.model.module.EAPDynamicModule;
import org.kie.integration.eap.maven.patch.EAPAbstractPatch;
import org.kie.integration.eap.maven.patch.EAPPatchException;
import org.kie.integration.eap.maven.template.assembly.EAPAssemblyTemplate;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;

public abstract class EAPDynamicModulesPatch
extends EAPAbstractPatch {
    protected EAPStaticLayerDistribution staticLayerDistribution;

    public void setStaticLayerDistribution(EAPStaticLayerDistribution staticLayerDistribution) {
        this.staticLayerDistribution = staticLayerDistribution;
    }

    public EAPStaticLayerDistribution getStaticLayerDistribution() {
        return this.staticLayerDistribution;
    }

    public abstract void execute(EAPModuleGraphNode var1, Properties var2) throws EAPPatchException;

    @Override
    public void execute() throws EAPPatchException {
        if (this.staticLayerDistribution == null) {
            throw new EAPPatchException("The static layer is not set.", this.getId());
        }
        if (this.staticLayerDistribution.getGraph() == null) {
            throw new EAPPatchException("The static layer graph is not set.", this.getId());
        }
        List<EAPModuleGraphNode> nodes = this.staticLayerDistribution.getGraph().getNodes();
        if (nodes != null && !nodes.isEmpty()) {
            for (EAPModuleGraphNode node : nodes) {
                Properties nodePatchProperties = this.getNodePatchProperties(node);
                if (nodePatchProperties == null || nodePatchProperties.isEmpty()) continue;
                this.execute(node, nodePatchProperties);
            }
        }
    }

    public Properties getNodePatchProperties(EAPModuleGraphNode node) {
        Properties p = node.getProperties();
        return this.getPatchProperties(p);
    }

    protected Artifact getArtifact(EAPModuleGraphNode module, String coordinates) {
        if (coordinates == null || coordinates.trim().length() == 0) {
            return null;
        }
        Artifact source = EAPArtifactUtils.createArtifact(coordinates);
        List<EAPModuleGraphNodeResource> resources = module.getResources();
        if (resources != null && !resources.isEmpty()) {
            for (EAPModuleGraphNodeResource resource : resources) {
                try {
                    Artifact resourceArtifact = (Artifact)resource.getResource();
                    if (EAPArtifactUtils.equals(source, resourceArtifact)) {
                        return resourceArtifact;
                    }
                    if (!EAPArtifactUtils.equalsNoVersion(source, resourceArtifact)) continue;
                    return resourceArtifact;
                }
                catch (ClassCastException e) {
                }
            }
        }
        return null;
    }

    public void patchAssembly(EAPDynamicModule module, EAPAssemblyTemplate assemblyTemplate) throws EAPPatchException {
    }
}

