/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.util;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Properties;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.impl.EnvironmentFactory;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUtil {
    private static Logger logger = LoggerFactory.getLogger(PersistenceUtil.class);
    private static boolean TEST_MARSHALLING = true;
    public static final String DROOLS_PERSISTENCE_UNIT_NAME = "org.drools.persistence.jpa";
    public static final String DROOLS_LOCAL_PERSISTENCE_UNIT_NAME = "org.drools.persistence.jpa.local";
    public static final String JBPM_PERSISTENCE_UNIT_NAME = "org.jbpm.persistence.jpa";
    public static final String JBPM_LOCAL_PERSISTENCE_UNIT_NAME = "org.jbpm.persistence.jpa.local";
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private static Properties defaultProperties = null;
    public static String DATASOURCE = "org.droolsjbpm.persistence.datasource";

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, true);
    }

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName, boolean testMarshalling) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, "jdbc/testDS1", testMarshalling);
    }

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName, String dataSourceName, boolean testMarshalling) {
        try {
            TransactionManagerServices.getTransactionManager().setTransactionTimeout(300);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        PersistenceUtil.determineTestMarshalling(dsProps, testMarshalling);
        DefaultCacheManager cm = null;
        try {
            if (TEST_MARSHALLING) {
                cm = new DefaultCacheManager("infinispan.xml");
                UserTransaction ut = (UserTransaction)cm.getCache("jbpm-configured-cache").getAdvancedCache().getTransactionManager();
                context.put("org.kie.transaction.Transaction", ut);
            } else {
                cm = new DefaultCacheManager("infinispan.xml");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        context.put("org.kie.api.persistence.jpa.EntityManagerFactory", cm);
        return context;
    }

    private static void determineTestMarshalling(Properties dsProps, boolean useTestMarshallingInTestMethod) {
        Object testMarshallingProperty = dsProps.get("testMarshalling");
        if ("true".equals(testMarshallingProperty)) {
            TEST_MARSHALLING = true;
            if (!useTestMarshallingInTestMethod) {
                TEST_MARSHALLING = false;
            }
        } else {
            TEST_MARSHALLING = false;
        }
    }

    public static void cleanUp(HashMap<String, Object> context) {
        if (context != null) {
            BitronixTransactionManager txm;
            Object emfObject = context.remove("org.kie.api.persistence.jpa.EntityManagerFactory");
            if (emfObject != null) {
                try {
                    DefaultCacheManager cm = (DefaultCacheManager)emfObject;
                    Cache cache = cm.getCache("jbpm-configured-cache");
                    TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
                    boolean txOwner = false;
                    if (tm.getStatus() == 6) {
                        tm.begin();
                        txOwner = true;
                    }
                    if (tm.getStatus() != 0) {
                        tm.rollback();
                        tm.begin();
                        txOwner = true;
                    }
                    cache.clear();
                    if (txOwner) {
                        tm.commit();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if ((txm = TransactionManagerServices.getTransactionManager()) != null) {
                txm.shutdown();
            }
        }
    }

    private static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", "url", "user", "password", "driverClassName", "className", "maxPoolSize", "allowLocalTransactions"};
            String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:tcp://localhost/JPADroolsFlow", "sa", "", "org.h2.Driver", "bitronix.tm.resource.jdbc.lrc.LrcXADataSource", "16", "true"};
            Assert.assertTrue((String)"Unequal number of keys for default properties", (keyArr.length == defaultPropArr.length ? 1 : 0) != 0);
            defaultProperties = new Properties();
            for (int i = 0; i < keyArr.length; ++i) {
                defaultProperties.put(keyArr[i], defaultPropArr[i]);
            }
        }
        return defaultProperties;
    }

    public static Properties getDatasourceProperties() {
        String password;
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = PersistenceUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        Assert.assertNotNull((String)propertiesNotFoundMessage, (Object)propsInputStream);
        Properties props = new Properties();
        if (propsInputStream != null) {
            try {
                props.load(propsInputStream);
            }
            catch (IOException ioe) {
                propertiesNotFound = true;
                logger.warn("Unable to find properties, using default H2 properties: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        } else {
            propertiesNotFound = true;
        }
        if ("${maven.jdbc.password}".equals(password = props.getProperty("password")) || propertiesNotFound) {
            props = PersistenceUtil.getDefaultProperties();
        }
        return props;
    }

    public static Object getValueOfField(String fieldname, Object source) {
        String sourceClassName = source.getClass().getSimpleName();
        Field field = null;
        try {
            field = source.getClass().getDeclaredField(fieldname);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        Assert.assertNotNull((String)("." + fieldname + " field is null!?!"), (Object)field);
        Object fieldValue = null;
        try {
            fieldValue = field.get(source);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        return fieldValue;
    }

    public static Environment createEnvironment(HashMap<String, Object> context) {
        Environment env = EnvironmentFactory.newEnvironment();
        UserTransaction ut = (UserTransaction)context.get("org.kie.transaction.Transaction");
        if (ut != null) {
            env.set("org.kie.transaction.Transaction", (Object)ut);
        }
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", context.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        env.set("org.kie.Globals", (Object)new MapGlobalResolver());
        return env;
    }

    public static StatefulKnowledgeSession createKnowledgeSessionFromKBase(KnowledgeBase kbase, HashMap<String, Object> context) {
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        StatefulKnowledgeSession knowledgeSession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)ksconf, (Environment)PersistenceUtil.createEnvironment(context));
        return knowledgeSession;
    }

    public static boolean testMarshalling() {
        return TEST_MARSHALLING;
    }
}

