/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.runtime.manager.impl.KModuleRegisterableItemsFactory;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

public class SpringRegisterableItemsFactory
extends KModuleRegisterableItemsFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringRegisterableItemsFactory.class);
    private Map<String, WorkItemHandler> handlers;
    private List<ProcessEventListener> processEventListeners;
    private List<AgendaEventListener> agendaEventListeners;
    private List<RuleRuntimeEventListener> ruleRuntimeEventListeners;
    private List<TaskLifeCycleEventListener> taskListeners;
    private ApplicationContext context;

    public SpringRegisterableItemsFactory(ApplicationContext context, KieContainer kieContainer, String ksessionName) {
        super(kieContainer, ksessionName);
        this.context = context;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
        Map workItemHandlers = super.getWorkItemHandlers(runtime);
        this.processHandlers();
        workItemHandlers.putAll(this.handlers);
        return workItemHandlers;
    }

    public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
        List listeners = super.getProcessEventListeners(runtime);
        this.processProcessEventListeners();
        listeners.addAll(this.processEventListeners);
        return listeners;
    }

    public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
        List listeners = super.getAgendaEventListeners(runtime);
        this.processAgendaEventListeners();
        listeners.addAll(this.agendaEventListeners);
        return listeners;
    }

    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners(RuntimeEngine runtime) {
        List listeners = super.getRuleRuntimeEventListeners(runtime);
        this.processRuleRuntimeEventListeners();
        listeners.addAll(this.ruleRuntimeEventListeners);
        return listeners;
    }

    public List<TaskLifeCycleEventListener> getTaskListeners() {
        List listeners = super.getTaskListeners();
        this.processTaskEventListeners();
        listeners.addAll(this.taskListeners);
        return listeners;
    }

    protected void processHandlers() {
        if (this.handlers == null) {
            this.handlers = new HashMap<String, WorkItemHandler>();
            Map foundBeans = this.context.getBeansOfType(WorkItemHandler.class);
            for (WorkItemHandler handler : foundBeans.values()) {
                String name = this.getComponentName(handler);
                if (name != null && !name.toString().isEmpty()) {
                    logger.debug("Registering {} work item handler under name {}", (Object)handler, (Object)name);
                    this.handlers.put(name.toString(), handler);
                    continue;
                }
                logger.warn("Not possible to register {} handler due to missing name - annotate your class with @Component with given name", (Object)handler);
            }
        }
    }

    protected void processAgendaEventListeners() {
        if (this.agendaEventListeners == null) {
            this.agendaEventListeners = new ArrayList<AgendaEventListener>();
            Map foundBeans = this.context.getBeansOfType(AgendaEventListener.class);
            for (AgendaEventListener listener : foundBeans.values()) {
                logger.debug("Registering {} agenda event listener", (Object)listener);
                this.agendaEventListeners.add(listener);
            }
        }
    }

    protected void processRuleRuntimeEventListeners() {
        if (this.ruleRuntimeEventListeners == null) {
            this.ruleRuntimeEventListeners = new ArrayList<RuleRuntimeEventListener>();
            Map foundBeans = this.context.getBeansOfType(RuleRuntimeEventListener.class);
            for (RuleRuntimeEventListener listener : foundBeans.values()) {
                logger.debug("Registering {} rule runtime event listener", (Object)listener);
                this.ruleRuntimeEventListeners.add(listener);
            }
        }
    }

    protected void processTaskEventListeners() {
        if (this.taskListeners == null) {
            this.taskListeners = new ArrayList<TaskLifeCycleEventListener>();
            Map foundBeans = this.context.getBeansOfType(TaskLifeCycleEventListener.class);
            for (TaskLifeCycleEventListener listener : foundBeans.values()) {
                logger.debug("Registering {} task event listener", (Object)listener);
                this.taskListeners.add(listener);
            }
        }
    }

    protected void processProcessEventListeners() {
        if (this.processEventListeners == null) {
            this.processEventListeners = new ArrayList<ProcessEventListener>();
            Map foundBeans = this.context.getBeansOfType(ProcessEventListener.class);
            for (ProcessEventListener listener : foundBeans.values()) {
                logger.debug("Registering {} process event listener", (Object)listener);
                this.processEventListeners.add(listener);
            }
        }
    }

    protected String getComponentName(Object component) {
        String name = null;
        if (component.getClass().isAnnotationPresent(Component.class)) {
            name = component.getClass().getAnnotation(Component.class).value();
        } else if (component.getClass().isAnnotationPresent(Wid.class)) {
            name = component.getClass().getAnnotation(Wid.class).name();
        }
        return name;
    }
}

