/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.kie.internal.identity.IdentityProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityIdentityProvider
implements IdentityProvider {
    private Stack<String> contextUsers = new Stack();

    public void setContextIdentity(String userId) {
        this.contextUsers.push(userId);
    }

    public void removeContextIdentity() {
        this.contextUsers.pop();
    }

    public String getName() {
        if (!this.contextUsers.isEmpty()) {
            return this.contextUsers.peek();
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            return auth.getName();
        }
        return "unknown";
    }

    public List<String> getRoles() {
        if (!this.contextUsers.isEmpty()) {
            return Collections.emptyList();
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            ArrayList<String> roles = new ArrayList<String>();
            for (GrantedAuthority ga : auth.getAuthorities()) {
                String roleName = ga.getAuthority();
                if (roleName.startsWith("ROLE_")) {
                    roleName = roleName.replaceFirst("ROLE_", "");
                }
                roles.add(roleName);
            }
            return roles;
        }
        return Collections.emptyList();
    }

    public boolean hasRole(String role) {
        return false;
    }
}

