/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.autoconfigure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.jbpm.springboot.persistence.JBPMPersistenceUnitPostProcessor;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.util.ClassUtils;

public final class EntityManagerFactoryHelper {
    private static final String CLASS_RESOURCE_PATTERN = "/**/*.class";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";

    private EntityManagerFactoryHelper() {
    }

    public static LocalContainerEntityManagerFactoryBean create(ApplicationContext applicationContext, DataSource dataSource, JpaProperties jpaProperties, String puName, String location) {
        LocalContainerEntityManagerFactoryBean factoryBean = new LocalContainerEntityManagerFactoryBean();
        factoryBean.setPersistenceUnitName(puName);
        factoryBean.setPersistenceXmlLocation(location);
        factoryBean.setJtaDataSource(dataSource);
        factoryBean.setJpaPropertyMap(jpaProperties.getProperties());
        HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter();
        adapter.setPrepareConnection(false);
        factoryBean.setJpaVendorAdapter((JpaVendorAdapter)adapter);
        ArrayList<1> postProcessors = new ArrayList<1>();
        final String packagesToScan = (String)jpaProperties.getProperties().get("entity-scan-packages");
        if (packagesToScan != null) {
            postProcessors.add(new PersistenceUnitPostProcessor(){

                public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
                    LinkedHashSet<TypeFilter> entityTypeFilters = new LinkedHashSet<TypeFilter>(3);
                    entityTypeFilters.add((TypeFilter)new AnnotationTypeFilter(Entity.class, false));
                    entityTypeFilters.add((TypeFilter)new AnnotationTypeFilter(Embeddable.class, false));
                    entityTypeFilters.add((TypeFilter)new AnnotationTypeFilter(MappedSuperclass.class, false));
                    PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
                    for (String pkg : packagesToScan.split(",")) {
                        try {
                            String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + EntityManagerFactoryHelper.CLASS_RESOURCE_PATTERN;
                            Resource[] resources = resourcePatternResolver.getResources(pattern);
                            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
                            for (Resource resource : resources) {
                                if (!resource.isReadable()) continue;
                                MetadataReader reader = readerFactory.getMetadataReader(resource);
                                String className = reader.getClassMetadata().getClassName();
                                if (this.matchesFilter(reader, (MetadataReaderFactory)readerFactory, entityTypeFilters)) {
                                    pui.addManagedClassName(className);
                                    continue;
                                }
                                if (!className.endsWith(EntityManagerFactoryHelper.PACKAGE_INFO_SUFFIX)) continue;
                                pui.addManagedPackage(className.substring(0, className.length() - EntityManagerFactoryHelper.PACKAGE_INFO_SUFFIX.length()));
                            }
                        }
                        catch (IOException ex) {
                            throw new PersistenceException("Failed to scan classpath for unlisted entity classes", (Throwable)ex);
                        }
                    }
                }

                private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory, Set<TypeFilter> entityTypeFilters) throws IOException {
                    for (TypeFilter filter : entityTypeFilters) {
                        if (!filter.match(reader, readerFactory)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        postProcessors.addAll(applicationContext.getBeansOfType(JBPMPersistenceUnitPostProcessor.class).values());
        factoryBean.setPersistenceUnitPostProcessors(postProcessors.toArray(new PersistenceUnitPostProcessor[0]));
        return factoryBean;
    }
}

