/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jbpm.executor.AsynchronousJobEvent;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.commands.LogCleanupCommand;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.springboot.samples.JBPMApplication;
import org.jbpm.springboot.samples.TestAutoConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.query.QueryContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={JBPMApplication.class, TestAutoConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-executor.properties"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class ExecutorJobsTest {
    @Autowired
    private ExecutorService executorService;

    @Before
    public void configure() {
        this.executorService.init();
    }

    @After
    public void close() {
        this.executorService.destroy();
    }

    @Test
    public void testLogCleanupCommand() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener(new AsynchronousJobListener(){

            public void beforeJobScheduled(AsynchronousJobEvent event) {
            }

            public void beforeJobExecuted(AsynchronousJobEvent event) {
            }

            public void beforeJobCancelled(AsynchronousJobEvent event) {
            }

            public void afterJobScheduled(AsynchronousJobEvent event) {
            }

            public void afterJobExecuted(AsynchronousJobEvent event) {
                latch.countDown();
            }

            public void afterJobCancelled(AsynchronousJobEvent event) {
            }
        });
        CommandContext commandContext = new CommandContext();
        commandContext.setData("EmfName", (Object)"org.jbpm.domain");
        commandContext.setData("SkipProcessLog", (Object)"false");
        commandContext.setData("SkipTaskLog", (Object)"false");
        commandContext.setData("SkipExecutorLog", (Object)"false");
        commandContext.setData("SingleRun", (Object)"true");
        long jobId = this.executorService.scheduleRequest(LogCleanupCommand.class.getName(), commandContext);
        Assert.assertNotNull((Object)jobId);
        latch.await(10L, TimeUnit.SECONDS);
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)completed.size());
    }
}

