/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples.listeners;

import java.util.concurrent.CountDownLatch;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.springframework.stereotype.Component;

@Component
public class CountDownLatchEventListener
extends DefaultProcessEventListener {
    private String expectedProcessId;
    private CountDownLatch latch;
    private String expectedNodeName;
    private String executingThread;

    public void configure(String processId, int threads) {
        this.expectedProcessId = processId;
        this.latch = new CountDownLatch(threads);
    }

    public void configureNode(String processId, String nodeName, int threads) {
        this.configure(processId, threads);
        this.expectedNodeName = nodeName;
    }

    public CountDownLatch getCountDown() {
        return this.latch;
    }

    public String getExecutingThread() {
        return this.executingThread;
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        if (this.latch != null && event.getProcessInstance().getProcessId().equals(this.expectedProcessId)) {
            this.executingThread = Thread.currentThread().getName();
            this.latch.countDown();
        }
    }

    public void afterNodeLeft(ProcessNodeLeftEvent processNodeLeftEvent) {
        if (this.latch != null && this.expectedNodeName != null && this.expectedNodeName.equals(processNodeLeftEvent.getNodeInstance().getNodeName())) {
            this.executingThread = Thread.currentThread().getName();
            this.latch.countDown();
        }
    }
}

