/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import io.smallrye.reactive.messaging.ce.OutgoingCloudEventMetadata;
import io.smallrye.reactive.messaging.ce.OutgoingCloudEventMetadataBuilder;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import org.kie.kogito.addon.quarkus.common.reactive.messaging.MessageDecoratorProvider;
import org.kie.kogito.event.CloudEventMarshaller;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuarkusCloudEventEmitter<M>
implements EventEmitter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQuarkusCloudEventEmitter.class);
    @Inject
    MessageDecoratorProvider messageDecorator;
    private CloudEventMarshaller<M> cloudEventMarshaller;
    private EventMarshaller<M> eventMarshaller;

    public CompletionStage<Void> emit(DataEvent<?> dataEvent) {
        logger.debug("publishing event {}", dataEvent);
        try {
            Message message = this.messageDecorator.decorate(this.getMessage(dataEvent)).withNack(e -> {
                logger.error("Error publishing event {}", (Object)dataEvent, e);
                return CompletableFuture.completedFuture(null);
            });
            this.emit(message);
            return (CompletionStage)message.getAck().get();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    protected void setEventDataMarshaller(EventMarshaller<M> marshaller) {
        this.eventMarshaller = marshaller;
    }

    protected void setCloudEventMarshaller(CloudEventMarshaller<M> marshaller) {
        this.cloudEventMarshaller = marshaller;
    }

    private <T> Optional<OutgoingCloudEventMetadata<?>> getMetadata(DataEvent<T> event) {
        if (event.getId() == null || event.getType() == null || event.getSource() == null || event.getSpecVersion() == null) {
            return Optional.empty();
        }
        OutgoingCloudEventMetadataBuilder builder = OutgoingCloudEventMetadata.builder().withId(event.getId()).withSource(event.getSource()).withType(event.getType()).withSubject(event.getSubject()).withDataContentType(event.getDataContentType()).withDataSchema(event.getDataSchema()).withSpecVersion(event.getSpecVersion().toString()).withTimestamp(event.getTime().toZonedDateTime());
        for (String extName : event.getExtensionNames()) {
            builder.withExtension(extName, event.getExtension(extName));
        }
        return Optional.of(builder.build());
    }

    private <T> Message<M> getMessage(DataEvent<T> event) throws IOException {
        if (this.cloudEventMarshaller != null) {
            return Message.of((Object)this.cloudEventMarshaller.marshall(event.asCloudEvent(this.cloudEventMarshaller.cloudEventDataFactory())));
        }
        if (this.eventMarshaller != null) {
            Optional<OutgoingCloudEventMetadata<?>> metadata = this.getMetadata(event);
            Object payload = this.eventMarshaller.marshall(event.getData());
            return metadata.isPresent() ? Message.of((Object)payload, (Metadata)Metadata.of((Object[])new Object[]{metadata.orElseThrow()})) : Message.of((Object)payload);
        }
        throw new IllegalStateException("Not marshaller has been set for emitter " + this);
    }

    protected abstract void emit(Message<M> var1);
}

