/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.kie.kogito.addon.cloudevents.AbstractTopicDiscovery;
import org.kie.kogito.event.ChannelType;
import org.kie.kogito.event.Topic;

@ApplicationScoped
@Priority(value=0)
public class QuarkusTopicDiscovery
extends AbstractTopicDiscovery {
    private static final String OUTGOING_PREFIX = "mp.messaging.outgoing.";
    private static final String INCOMING_PREFIX = "mp.messaging.incoming.";
    private static final String TOPIC_SUFFIX = ".topic";

    protected List<Topic> getTopics() {
        ArrayList<Topic> topics = new ArrayList<Topic>();
        this.getPropertyNames().forEach(n -> {
            if (n.startsWith(OUTGOING_PREFIX)) {
                String topicName = this.extractChannelName((String)n, OUTGOING_PREFIX);
                if (topics.stream().noneMatch(t -> t.getName().equals(topicName) && t.getType() == ChannelType.OUTGOING)) {
                    Topic topic = new Topic();
                    topic.setType(ChannelType.OUTGOING);
                    topic.setName(topicName);
                    topics.add(topic);
                }
            } else if (n.startsWith(INCOMING_PREFIX)) {
                String topicName = this.extractChannelName((String)n, INCOMING_PREFIX);
                if (topics.stream().noneMatch(t -> t.getName().equals(topicName) && t.getType() == ChannelType.INCOMING)) {
                    Topic topic = new Topic();
                    topic.setType(ChannelType.INCOMING);
                    topic.setName(topicName);
                    topics.add(topic);
                }
            }
        });
        return topics;
    }

    private String extractChannelName(String property, String prefix) {
        String channelName = property.substring(prefix.length());
        if (channelName.contains(".")) {
            channelName = channelName.substring(0, channelName.indexOf("."));
        }
        Optional<String> topicName = this.getOptionalValue(prefix + channelName + TOPIC_SUFFIX);
        return topicName.orElse(channelName);
    }

    Iterable<String> getPropertyNames() {
        return ConfigProvider.getConfig().getPropertyNames();
    }

    Optional<String> getOptionalValue(String key) {
        return ConfigProvider.getConfig().getOptionalValue(key, String.class);
    }
}

