/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.rest;

import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.kie.kogito.svg.ProcessSvgService;

@ApplicationScoped
@Path(value="/svg")
public class ProcessSvgResource {
    @Inject
    ProcessSvgService service;
    @Inject
    SecurityIdentity identity;

    @GET
    @Path(value="processes/{processId}")
    @Produces(value={"image/svg+xml"})
    public Response getProcessSvg(@PathParam(value="processId") String processId) {
        Optional processSvg = this.service.getProcessSvg(processId);
        if (processSvg.isPresent()) {
            return Response.ok(processSvg.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="processes/{processId}/instances/{processInstanceId}")
    @Produces(value={"image/svg+xml"})
    public Response getExecutionPathByProcessInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @HeaderParam(value="Authorization") @DefaultValue(value="") String authHeader) {
        Optional processInstanceSvg = this.service.getProcessInstanceSvg(processId, processInstanceId, this.getAuthHeader(authHeader));
        if (processInstanceSvg.isPresent()) {
            return Response.ok(processInstanceSvg.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Inject
    protected void setProcessSvgService(ProcessSvgService service) {
        this.service = service;
    }

    protected String getAuthHeader(String authHeader) {
        if (this.identity != null && !this.identity.isAnonymous() && this.identity.getCredential(TokenCredential.class) != null) {
            return "Bearer " + ((TokenCredential)this.identity.getCredential(TokenCredential.class)).getToken();
        }
        return authHeader;
    }
}

