/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files.deployment;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import org.kie.kogito.addon.source.files.SourceFilesRecorder;
import org.kie.kogito.codegen.api.SourceFileCodegenBindEvent;
import org.kie.kogito.codegen.api.SourceFileCodegenBindListener;
import org.kie.kogito.source.files.SourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SourceFileCodegenBindListenerImpl
implements SourceFileCodegenBindListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceFileCodegenBindListenerImpl.class);
    private final File[] resourcePaths;
    private final SourceFilesRecorder sourceFilesRecorder;

    protected SourceFileCodegenBindListenerImpl(File[] resourcePaths, SourceFilesRecorder sourceFilesRecorder) {
        this.resourcePaths = resourcePaths;
        this.sourceFilesRecorder = sourceFilesRecorder;
    }

    public void onSourceFileCodegenBind(SourceFileCodegenBindEvent event) {
        LOGGER.debug("Received event {}", (Object)event);
        Path sourceFilePath = Path.of(event.getUri(), new String[0]);
        Arrays.stream(this.resourcePaths).map(File::toPath).filter(sourceFilePath::startsWith).findFirst().ifPresentOrElse(resourcePath -> {
            SourceFile sourceFile = new SourceFile(this.resolveSourceFilePath(sourceFilePath, (Path)resourcePath));
            this.sourceFilesRecorder.addSourceFile(event.getSourceFileId(), sourceFile);
        }, () -> this.sourceFilesRecorder.addSourceFile(event.getSourceFileId(), new SourceFile(event.getUri())));
    }

    private String resolveSourceFilePath(Path sourceFilePath, Path locationPath) {
        return sourceFilePath.subpath(locationPath.getNameCount(), sourceFilePath.getNameCount()).toString();
    }
}

