/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.builder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.kie.api.builder.ReleaseId;

public class ReleaseIdComparator
implements Comparator<ReleaseId> {
    private final SortDirection sortDirection;

    public ReleaseIdComparator() {
        this(SortDirection.ASCENDING);
    }

    public ReleaseIdComparator(SortDirection sortDirection) {
        if (sortDirection == null) {
            throw new IllegalArgumentException("sort direction must be defined");
        }
        this.sortDirection = sortDirection;
    }

    @Override
    public int compare(ReleaseId o1, ReleaseId o2) {
        int result = 0;
        if (o1 != o2) {
            result = o1.getGroupId().compareTo(o2.getGroupId());
            if (result == 0 && (result = o1.getArtifactId().compareTo(o2.getArtifactId())) == 0) {
                result = new ComparableVersion(o1.getVersion()).compareTo(new ComparableVersion(o2.getVersion()));
            }
            if (result != 0 && SortDirection.DESCENDING.equals((Object)this.sortDirection)) {
                result *= -1;
            }
        }
        return result;
    }

    public static ReleaseId getEarliest(List<ReleaseId> releaseIds) {
        return ReleaseIdComparator.getFirstSorted(releaseIds, SortDirection.ASCENDING);
    }

    public static ReleaseId getLatest(List<ReleaseId> releaseIds) {
        return ReleaseIdComparator.getFirstSorted(releaseIds, SortDirection.DESCENDING);
    }

    private static ReleaseId getFirstSorted(List<ReleaseId> releaseIds, SortDirection sortDirection) {
        if (releaseIds != null && !releaseIds.isEmpty()) {
            releaseIds.sort(new ReleaseIdComparator(sortDirection));
            return releaseIds.get(0);
        }
        return null;
    }

    public static class ComparableVersion
    implements Comparable<ComparableVersion> {
        private String value;
        private String canonical;
        private ListItem items;

        public ComparableVersion(String version) {
            this.parseVersion(version);
        }

        public final void parseVersion(String version) {
            this.value = version;
            this.items = new ListItem();
            version = version.toLowerCase();
            ListItem list = this.items;
            ArrayDeque<ListItem> stack = new ArrayDeque<ListItem>();
            stack.push(list);
            boolean isDigit = false;
            int startIndex = 0;
            for (int i = 0; i < version.length(); ++i) {
                char c = version.charAt(i);
                if (c == '.') {
                    if (i == startIndex) {
                        list.add(IntegerItem.NULL_INTEGER);
                    } else {
                        list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                    }
                    startIndex = i + 1;
                    continue;
                }
                if (c == '-') {
                    if (i == startIndex) {
                        list.add(IntegerItem.NULL_INTEGER);
                    } else {
                        list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                    }
                    startIndex = i + 1;
                    if (!isDigit) continue;
                    list.normalize();
                    if (i + 1 >= version.length() || !Character.isDigit(version.charAt(i + 1))) continue;
                    ListItem listItem = list;
                    list = new ListItem();
                    listItem.add(list);
                    stack.push(list);
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (!isDigit && i > startIndex) {
                        list.add(new StringItem(version.substring(startIndex, i), true));
                        startIndex = i;
                    }
                    isDigit = true;
                    continue;
                }
                if (isDigit && i > startIndex) {
                    list.add(ComparableVersion.parseItem(true, version.substring(startIndex, i)));
                    startIndex = i;
                }
                isDigit = false;
            }
            if (version.length() > startIndex) {
                list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex)));
            }
            while (!stack.isEmpty()) {
                list = (ListItem)stack.pop();
                list.normalize();
            }
            this.canonical = this.items.toString();
        }

        private static Item parseItem(boolean isDigit, String buf) {
            return isDigit && buf.length() < 10 ? new IntegerItem(buf) : new StringItem(buf, false);
        }

        @Override
        public int compareTo(ComparableVersion o) {
            return this.items.compareTo(o.items);
        }

        public String toString() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ComparableVersion && this.canonical.equals(((ComparableVersion)o).canonical);
        }

        public int hashCode() {
            return this.canonical.hashCode();
        }

        private static class ListItem
        extends ArrayList<Item>
        implements Item {
            private ListItem() {
            }

            @Override
            public Item.ItemType getType() {
                return Item.ItemType.LIST_ITEM;
            }

            @Override
            public boolean isNull() {
                return this.size() == 0;
            }

            void normalize() {
                Item item;
                ListIterator iterator = this.listIterator(this.size());
                while (iterator.hasPrevious() && (item = (Item)iterator.previous()).isNull()) {
                    iterator.remove();
                }
            }

            @Override
            public int compareTo(Item item) {
                if (item == null) {
                    if (this.size() == 0) {
                        return 0;
                    }
                    Item first = (Item)this.get(0);
                    return first.compareTo(null);
                }
                switch (item.getType()) {
                    case INTEGER_ITEM: {
                        return -1;
                    }
                    case STRING_ITEM: {
                        return 1;
                    }
                    case LIST_ITEM: {
                        Iterator left = this.iterator();
                        Iterator right = ((ListItem)item).iterator();
                        while (left.hasNext() || right.hasNext()) {
                            Item l = left.hasNext() ? (Item)left.next() : null;
                            Item r = right.hasNext() ? (Item)right.next() : null;
                            int result = l == null ? -r.compareTo(l) : l.compareTo(r);
                            if (result == 0) continue;
                            return result;
                        }
                        return 0;
                    }
                }
                throw new IllegalArgumentException("invalid item: " + (Object)((Object)item.getType()));
            }

            @Override
            public String toString() {
                StringBuilder buffer = new StringBuilder("(");
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    buffer.append(iter.next());
                    if (!iter.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append(')');
                return buffer.toString();
            }
        }

        private static class StringItem
        implements Item {
            private static final String[] QUALIFIERS = new String[]{"alpha", "beta", "milestone", "rc", "snapshot", "", "sp"};
            private static final List<String> _QUALIFIERS = Arrays.asList(QUALIFIERS);
            private static final Map<String, String> ALIASES = new HashMap<String, String>();
            private static final String RELEASE_VERSION_INDEX;
            private String value;

            public StringItem(String value, boolean followedByDigit) {
                if (followedByDigit && value.length() == 1) {
                    switch (value.charAt(0)) {
                        case 'a': {
                            value = "alpha";
                            break;
                        }
                        case 'b': {
                            value = "beta";
                            break;
                        }
                        case 'm': {
                            value = "milestone";
                        }
                    }
                }
                this.value = ALIASES.containsKey(value) ? ALIASES.get(value) : value;
            }

            @Override
            public Item.ItemType getType() {
                return Item.ItemType.STRING_ITEM;
            }

            @Override
            public boolean isNull() {
                return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX) == 0;
            }

            public static String comparableQualifier(String qualifier) {
                int i = _QUALIFIERS.indexOf(qualifier);
                return i == -1 ? _QUALIFIERS.size() + "-" + qualifier : String.valueOf(i);
            }

            @Override
            public int compareTo(Item item) {
                if (item == null) {
                    return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX);
                }
                switch (item.getType()) {
                    case INTEGER_ITEM: {
                        return -1;
                    }
                    case STRING_ITEM: {
                        return StringItem.comparableQualifier(this.value).compareTo(StringItem.comparableQualifier(((StringItem)item).value));
                    }
                    case LIST_ITEM: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("invalid type: " + (Object)((Object)item.getType()));
            }

            public String toString() {
                return this.value;
            }

            static {
                ALIASES.put("ga", "");
                ALIASES.put("final", "");
                ALIASES.put("cr", "rc");
                RELEASE_VERSION_INDEX = String.valueOf(_QUALIFIERS.indexOf(""));
            }
        }

        private static class IntegerItem
        implements Item {
            private final int value;
            private static final IntegerItem NULL_INTEGER = new IntegerItem();

            private IntegerItem() {
                this.value = 0;
            }

            public IntegerItem(String str) {
                this.value = Integer.parseInt(str);
            }

            @Override
            public Item.ItemType getType() {
                return Item.ItemType.INTEGER_ITEM;
            }

            @Override
            public boolean isNull() {
                return this.value == 0;
            }

            @Override
            public int compareTo(Item item) {
                if (item == null) {
                    return this.value == 0 ? 0 : 1;
                }
                switch (item.getType()) {
                    case INTEGER_ITEM: {
                        return this.value - ((IntegerItem)item).value;
                    }
                    case STRING_ITEM: {
                        return 1;
                    }
                    case LIST_ITEM: {
                        return 1;
                    }
                }
                throw new IllegalArgumentException("invalid type: " + (Object)((Object)item.getType()));
            }

            public String toString() {
                return Integer.toString(this.value);
            }
        }

        private static interface Item {
            public int compareTo(Item var1);

            public ItemType getType();

            public boolean isNull();

            public static enum ItemType {
                INTEGER_ITEM,
                STRING_ITEM,
                LIST_ITEM;

            }
        }
    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }
}

