/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.util.ServiceLoader;

public interface KieService
extends Comparable<KieService> {
    public static final String UNDEFINED = "undefined";

    default public int servicePriority() {
        return 0;
    }

    default public String serviceTag() {
        return UNDEFINED;
    }

    @Override
    default public int compareTo(KieService other) {
        if (this.servicePriority() == other.servicePriority()) {
            throw new IllegalStateException("Found 2 services with same priority (" + this.servicePriority() + "): " + this.getClass().getCanonicalName() + " and " + other.getClass().getCanonicalName());
        }
        return this.servicePriority() - other.servicePriority();
    }

    public static <T extends KieService> T load(Class<T> serviceClass) {
        ServiceLoader<KieService> loader = ServiceLoader.load(serviceClass, serviceClass.getClassLoader());
        KieService service = null;
        for (KieService impl : loader) {
            if (service != null && impl.compareTo(service) <= 0) continue;
            service = impl;
        }
        return (T)service;
    }

    public static <T extends KieService> T loadWithTag(Class<T> serviceClass, String tag) {
        if (tag == null || tag.equals(UNDEFINED)) {
            return KieService.load(serviceClass);
        }
        ServiceLoader<KieService> loader = ServiceLoader.load(serviceClass, serviceClass.getClassLoader());
        KieService service = null;
        for (KieService impl : loader) {
            if (!tag.equals(impl.serviceTag())) continue;
            if (service == null) {
                service = impl;
                continue;
            }
            throw new IllegalStateException("Found 2 services with the same tag \"" + tag + "\": " + service.getClass().getCanonicalName() + " and " + impl.getClass().getCanonicalName());
        }
        return (T)service;
    }
}

