/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.kie.aries.blueprint.namespace.AbstractElementParser;
import org.kie.aries.blueprint.namespace.KieBaseElementParser;
import org.kie.aries.blueprint.namespace.KieEnvironmentElementParser;
import org.kie.aries.blueprint.namespace.KieEventListenersElementParser;
import org.kie.aries.blueprint.namespace.KieSessionElementParser;
import org.kie.aries.blueprint.namespace.KieStoreElementParser;
import org.kie.aries.blueprint.namespace.ReleaseIdElementParser;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KieNamespaceHandler
implements NamespaceHandler {
    public static final String NS_URI = "http://drools.org/schema/drools-aries-blueprint";
    private static final String BLUEPRINT_NS = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    public static final String ELEMENT_RELEASE_ID = "releaseId";
    public static final String ELEMENT_KBASE = "kbase-ref";
    public static final String ELEMENT_KSTORE = "kstore";
    public static final String ELEMENT_KSESSION = "ksession";
    public static final String ELEMENT_KSESSION_REF = "ksession-ref";
    public static final String ELEMENT_EVENT_LISTENERS = "eventListeners";
    public static final String ELEMENT_ENVIRONMENT = "environment";
    protected static Map<String, AbstractElementParser> droolsElementParserMap = new HashMap<String, AbstractElementParser>();

    public URL getSchemaLocation(String namespace) {
        if (NS_URI.equals(namespace)) {
            return this.getClass().getResource("org/kie/aries/blueprint/kie-aries-blueprint.xsd");
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        System.out.println("getManagedClasses ::");
        return null;
    }

    public Metadata parse(Element element, ParserContext parserContext) {
        String elementName = element.getLocalName();
        AbstractElementParser elementParser = droolsElementParserMap.get(elementName);
        if (elementParser == null) {
            throw new ComponentDefinitionException("Unsupported Kie Blueprint Element '" + elementName + "'");
        }
        return elementParser.parseElement(parserContext, element);
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata componentMetadata, ParserContext parserContext) {
        System.out.println("decorate ::" + node.getNodeName());
        return null;
    }

    static {
        droolsElementParserMap.put(ELEMENT_RELEASE_ID, new ReleaseIdElementParser());
        droolsElementParserMap.put(ELEMENT_KBASE, new KieBaseElementParser());
        droolsElementParserMap.put(ELEMENT_KSESSION, new KieSessionElementParser());
        droolsElementParserMap.put(ELEMENT_KSESSION_REF, new KieSessionElementParser());
        droolsElementParserMap.put(ELEMENT_EVENT_LISTENERS, new KieEventListenersElementParser());
        droolsElementParserMap.put(ELEMENT_KSTORE, new KieStoreElementParser());
        droolsElementParserMap.put(ELEMENT_ENVIRONMENT, new KieEnvironmentElementParser());
    }
}

