/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.factorybeans;

import java.util.HashMap;
import java.util.List;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.persistence.jpa.KnowledgeStoreServiceImpl;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.aries.blueprint.factorybeans.KieListenerAdaptor;
import org.kie.aries.blueprint.factorybeans.KieLoggerAdaptor;
import org.kie.aries.blueprint.factorybeans.KieObjectsResolver;
import org.kie.aries.blueprint.factorybeans.KieSessionFactoryBeanHelper;
import org.kie.aries.blueprint.helpers.JPAPlaceholderResolverStrategyHelper;
import org.osgi.service.blueprint.container.ComponentDefinitionException;

public class KieObjectsFactoryBean {
    public static KieBase fetchKBase(String id, ReleaseId releaseId) {
        System.out.println("fetchKBase :: " + id + ", releaseId:: " + releaseId);
        KieObjectsResolver kieObjectsResolver = KieObjectsResolver.get();
        return kieObjectsResolver.resolveKBase(id, null);
    }

    public static KieContainer fetchKContainer(ReleaseId releaseId) {
        System.out.println("fetchKContainer :: releaseId:: " + releaseId);
        KieObjectsResolver kieObjectsResolver = KieObjectsResolver.get();
        KieServices ks = KieServices.Factory.get();
        if (releaseId == null) {
            return ks.getKieClasspathContainer();
        }
        return ks.newKieContainer(releaseId);
    }

    public static Object createKieSessionRef(String id, ReleaseId releaseId, List<KieListenerAdaptor> listeners, List<KieLoggerAdaptor> loggers, List<?> commands) {
        System.out.println(id + "  " + commands);
        KieObjectsResolver kieObjectsResolver = KieObjectsResolver.get();
        Object obj = kieObjectsResolver.resolveKSession(id, releaseId);
        if (obj != null) {
            KieSessionFactoryBeanHelper.addListeners((KieRuntimeEventManager)obj, listeners);
            KieSessionFactoryBeanHelper.attachLoggers((KieRuntimeEventManager)obj, loggers);
            if (obj instanceof KieSession) {
                KieSessionFactoryBeanHelper.executeCommands((KieSession)obj, commands);
            }
            return obj;
        }
        throw new ComponentDefinitionException("No KSession found in kmodule.xml with id '" + id + "'.");
    }

    public static Object createKieSession(String id, ReleaseId releaseId, List<KieListenerAdaptor> listeners, List<KieLoggerAdaptor> loggers, List<?> commands, String kbaseRef, String type) {
        Object obj;
        KieObjectsResolver kieObjectsResolver = KieObjectsResolver.get();
        if ("stateless".equalsIgnoreCase(type)) {
            obj = kieObjectsResolver.newStatelessSession(kbaseRef, releaseId, null);
        } else {
            obj = kieObjectsResolver.newStatefulSession(kbaseRef, releaseId, null);
            KieSessionFactoryBeanHelper.executeCommands((KieSession)obj, commands);
        }
        KieSessionFactoryBeanHelper.addListeners((KieRuntimeEventManager)obj, listeners);
        KieSessionFactoryBeanHelper.attachLoggers((KieRuntimeEventManager)obj, loggers);
        return obj;
    }

    public static KieStoreServices createKieStore() throws Exception {
        KieObjectsResolver objectsResolver = KieObjectsResolver.get();
        return new KnowledgeStoreServiceImpl();
    }

    public static ReleaseId createReleaseId(String id, String groupId, String artifactId, String version) {
        return new ReleaseIdImpl(groupId, artifactId, version);
    }

    public static Environment createEnvironment(String id, HashMap<String, Object> parameters, List<Object> marshallingStrategies) {
        Environment environment = EnvironmentFactory.newEnvironment();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                environment.set(key, parameters.get(key));
            }
        }
        for (int i = 0; i < marshallingStrategies.size(); ++i) {
            Object object = marshallingStrategies.get(i);
            if (!(object instanceof JPAPlaceholderResolverStrategyHelper)) continue;
            Environment refEnv = ((JPAPlaceholderResolverStrategyHelper)object).getEnvironment();
            JPAPlaceholderResolverStrategy jpaPlaceholderResolverStrategy = refEnv == null ? new JPAPlaceholderResolverStrategy(environment) : new JPAPlaceholderResolverStrategy(refEnv);
            marshallingStrategies.set(i, jpaPlaceholderResolverStrategy);
            break;
        }
        if (marshallingStrategies != null) {
            environment.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)marshallingStrategies.toArray(new ObjectMarshallingStrategy[0]));
        }
        return environment;
    }

    public static ClassObjectMarshallingStrategyAcceptor createDefaultAcceptor() {
        return ClassObjectMarshallingStrategyAcceptor.DEFAULT;
    }
}

