/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.namespace;

import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableComponentMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractElementParser {
    public static final String ID_ATTRIBUTE = "id";
    private int idCounter;

    public String getAttributeValue(Node node, String attributeName) {
        if (node.getAttributes().getNamedItem(attributeName) != null) {
            return node.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        return null;
    }

    public String getId(ParserContext context, Element element) {
        if (element.hasAttribute(ID_ATTRIBUTE)) {
            return element.getAttribute(ID_ATTRIBUTE);
        }
        return this.generateId(context);
    }

    public String getId(ParserContext context, Node element) {
        if (element.getAttributes().getNamedItem(ID_ATTRIBUTE) != null) {
            return element.getAttributes().getNamedItem(ID_ATTRIBUTE).getNodeValue();
        }
        return this.generateId(context);
    }

    public void generateIdIfNeeded(ParserContext context, MutableComponentMetadata metadata) {
        if (metadata.getId() == null) {
            metadata.setId(this.generateId(context));
        }
    }

    protected NullMetadata createNullMetadata() {
        return new NullMetadata(){};
    }

    private String generateId(ParserContext context) {
        String id;
        do {
            id = ".drools-" + ++this.idCounter;
        } while (context.getComponentDefinitionRegistry().containsComponentDefinition(id));
        return id;
    }

    public int getIdCounter() {
        return this.idCounter;
    }

    public void setIdCounter(int idCounter) {
        this.idCounter = idCounter;
    }

    public static ValueMetadata createValue(ParserContext context, String value) {
        return AbstractElementParser.createValue(context, value, null);
    }

    public static ValueMetadata createValue(ParserContext context, String value, String type) {
        MutableValueMetadata m = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
        m.setStringValue(value);
        m.setType(type);
        return m;
    }

    public static ValueMetadata createValue(ParserContext context, int value) {
        return AbstractElementParser.createValue(context, value, "java.lang.Integer");
    }

    public static ValueMetadata createValue(ParserContext context, int value, String type) {
        MutableValueMetadata m = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
        m.setStringValue("" + value);
        m.setType(type);
        return m;
    }

    public static RefMetadata createRef(ParserContext context, String value) {
        MutableRefMetadata m = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
        m.setComponentId(value);
        return m;
    }

    public abstract Metadata parseElement(ParserContext var1, Element var2);
}

