/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.namespace;

import java.util.ArrayList;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.reflect.BeanArgumentImpl;
import org.apache.aries.blueprint.reflect.BeanMetadataImpl;
import org.apache.aries.blueprint.reflect.CollectionMetadataImpl;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.FireUntilHaltCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.util.StringUtils;
import org.kie.aries.blueprint.namespace.KieSessionElementParser;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class KieSessionBatchElementParser {
    public static final String LOGGER_ATTRIBUTE_FILE = "file";
    public static final String LOGGER_ATTRIBUTE_ID = "id";
    public static final String LOGGER_ATTRIBUTE_THREADED = "threaded";
    public static final String LOGGER_ATTRIBUTE_LOGGER_TYPE = "loggerType";
    public static final String LOGGER_ATTRIBUTE_INTERVAL = "interval";

    KieSessionBatchElementParser() {
    }

    public static CollectionMetadata parseBatchElement(KieSessionElementParser kieSessionElementParser, ParserContext context, Element element) {
        CollectionMetadataImpl collectionMetadata = (CollectionMetadataImpl)context.createMetadata(CollectionMetadataImpl.class);
        collectionMetadata.setCollectionClass(ArrayList.class);
        String prefix = element.getPrefix();
        NodeList batchNodeList = element.getElementsByTagName(prefix + ":batch");
        if (batchNodeList != null && batchNodeList.getLength() > 0) {
            Node batchNode = batchNodeList.item(0);
            for (int i = 0; i < batchNode.getChildNodes().getLength(); ++i) {
                BeanArgumentImpl argument;
                String ref;
                Node n = batchNode.getChildNodes().item(i);
                if (!(n instanceof Element)) continue;
                Element e = (Element)n;
                BeanMetadataImpl componentMetadata = (BeanMetadataImpl)context.createMetadata(BeanMetadataImpl.class);
                if ("insert-object".equals(e.getLocalName())) {
                    ref = e.getAttribute("ref");
                    if (StringUtils.isEmpty((CharSequence)ref)) {
                        throw new ComponentDefinitionException("'ref' attribute is missing for insert-object for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                    }
                    componentMetadata.setClassName(InsertObjectCommand.class.getName());
                    argument = new BeanArgumentImpl();
                    argument.setIndex(0);
                    argument.setValue((Metadata)KieSessionElementParser.createRef(context, ref));
                    componentMetadata.addArgument((BeanArgument)argument);
                } else if ("set-global".equals(e.getLocalName())) {
                    ref = e.getAttribute("ref");
                    if (StringUtils.isEmpty((CharSequence)ref)) {
                        throw new ComponentDefinitionException("'ref' attribute is missing for set-global for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                    }
                    String identifier = e.getAttribute("identifier");
                    if (StringUtils.isEmpty((CharSequence)identifier)) {
                        throw new ComponentDefinitionException("'identifier' attribute is missing for set-global for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                    }
                    componentMetadata.setClassName(SetGlobalCommand.class.getName());
                    BeanArgumentImpl argument2 = new BeanArgumentImpl();
                    argument2.setIndex(0);
                    argument2.setValue((Metadata)KieSessionElementParser.createValue(context, identifier));
                    componentMetadata.addArgument((BeanArgument)argument2);
                    argument2 = new BeanArgumentImpl();
                    argument2.setIndex(1);
                    argument2.setValue((Metadata)KieSessionElementParser.createRef(context, ref));
                    componentMetadata.addArgument((BeanArgument)argument2);
                } else if ("fire-until-halt".equals(e.getLocalName())) {
                    componentMetadata.setClassName(FireUntilHaltCommand.class.getName());
                } else if ("fire-all-rules".equals(e.getLocalName())) {
                    componentMetadata.setClassName(FireAllRulesCommand.class.getName());
                    String max = e.getAttribute("max");
                    if (!StringUtils.isEmpty((CharSequence)max)) {
                        try {
                            argument = new BeanArgumentImpl();
                            argument.setIndex(0);
                            argument.setValue((Metadata)KieSessionElementParser.createValue(context, Integer.parseInt(max)));
                            componentMetadata.addArgument((BeanArgument)argument);
                        }
                        catch (NumberFormatException e1) {}
                    }
                } else if (!"start-process".equals(e.getLocalName())) {
                    if ("signal-event".equals(e.getLocalName())) {
                        String ref2;
                        componentMetadata.setClassName(SignalEventCommand.class.getName());
                        String processInstanceId = e.getAttribute("process-instance-id");
                        argument = null;
                        int index = 0;
                        if (!StringUtils.isEmpty((CharSequence)processInstanceId)) {
                            argument = new BeanArgumentImpl();
                            try {
                                argument.setValue((Metadata)KieSessionElementParser.createValue(context, Integer.parseInt(processInstanceId)));
                            }
                            catch (NumberFormatException e1) {
                                // empty catch block
                            }
                            componentMetadata.addArgument((BeanArgument)argument);
                            ++index;
                        }
                        if (StringUtils.isEmpty((CharSequence)(ref2 = e.getAttribute("ref")))) {
                            throw new ComponentDefinitionException("'ref' attribute is missing for signal-event for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                        }
                        String eventType = e.getAttribute("event-type");
                        if (StringUtils.isEmpty((CharSequence)eventType)) {
                            throw new ComponentDefinitionException("'event-type' attribute is missing for signal-event for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                        }
                        argument = new BeanArgumentImpl();
                        argument.setIndex(index++);
                        argument.setValue((Metadata)KieSessionElementParser.createRef(context, ref2));
                        componentMetadata.addArgument((BeanArgument)argument);
                        argument = new BeanArgumentImpl();
                        argument.setIndex(index++);
                        argument.setValue((Metadata)KieSessionElementParser.createValue(context, eventType));
                        componentMetadata.addArgument((BeanArgument)argument);
                    } else {
                        throw new ComponentDefinitionException("Unknown child element found in batch element.");
                    }
                }
                collectionMetadata.addValue((Metadata)componentMetadata);
            }
        }
        return collectionMetadata;
    }

    private static Element getFirstElement(NodeList list) {
        int lengthj = list.getLength();
        for (int j = 0; j < lengthj; ++j) {
            if (!(list.item(j) instanceof Element)) continue;
            return (Element)list.item(j);
        }
        return null;
    }
}

