/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.namespace;

import java.util.ArrayList;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableComponentMetadata;
import org.apache.aries.blueprint.reflect.BeanMetadataImpl;
import org.apache.aries.blueprint.reflect.CollectionMetadataImpl;
import org.apache.aries.blueprint.reflect.RefMetadataImpl;
import org.drools.core.util.StringUtils;
import org.kie.aries.blueprint.factorybeans.KieLoggerAdaptor;
import org.kie.aries.blueprint.namespace.ExpressionUtils;
import org.kie.aries.blueprint.namespace.KieSessionElementParser;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class KieSessionLoggerElementParser {
    public static final String LOGGER_ATTRIBUTE_FILE = "file";
    public static final String LOGGER_ATTRIBUTE_ID = "id";
    public static final String LOGGER_ATTRIBUTE_THREADED = "threaded";
    public static final String LOGGER_ATTRIBUTE_LOGGER_TYPE = "loggerType";
    public static final String LOGGER_ATTRIBUTE_INTERVAL = "interval";

    KieSessionLoggerElementParser() {
    }

    public static CollectionMetadata parseConsoleLoggers(KieSessionElementParser kieLoggerElementParser, ParserContext context, Element element) {
        NodeList fileLoggerList;
        CollectionMetadataImpl collectionMetadata = (CollectionMetadataImpl)context.createMetadata(CollectionMetadataImpl.class);
        collectionMetadata.setCollectionClass(ArrayList.class);
        String prefix = element.getPrefix();
        NodeList consoleLoggerList = element.getElementsByTagName(prefix + ":consoleLogger");
        if (consoleLoggerList != null && consoleLoggerList.getLength() > 0) {
            for (int i = 0; i < consoleLoggerList.getLength(); ++i) {
                Node loggerNode = consoleLoggerList.item(i);
                BeanMetadataImpl componentMetadata = (BeanMetadataImpl)context.createMetadata(BeanMetadataImpl.class);
                componentMetadata.setId(kieLoggerElementParser.getId(context, loggerNode));
                kieLoggerElementParser.generateIdIfNeeded(context, (MutableComponentMetadata)componentMetadata);
                componentMetadata.setClassName(KieLoggerAdaptor.class.getName());
                context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)componentMetadata);
                RefMetadataImpl refMetadata = (RefMetadataImpl)context.createMetadata(RefMetadataImpl.class);
                refMetadata.setComponentId(componentMetadata.getId());
                collectionMetadata.addValue((Metadata)refMetadata);
            }
        }
        if ((fileLoggerList = element.getElementsByTagName(prefix + ":fileLogger")) != null && fileLoggerList.getLength() > 0) {
            for (int i = 0; i < fileLoggerList.getLength(); ++i) {
                Node loggerNode = fileLoggerList.item(i);
                BeanMetadataImpl componentMetadata = (BeanMetadataImpl)context.createMetadata(BeanMetadataImpl.class);
                String id = kieLoggerElementParser.getId(context, loggerNode);
                if (id != null) {
                    componentMetadata.setId(id);
                }
                kieLoggerElementParser.generateIdIfNeeded(context, (MutableComponentMetadata)componentMetadata);
                context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)componentMetadata);
                componentMetadata.setClassName(KieLoggerAdaptor.class.getName());
                String fileName = kieLoggerElementParser.getAttributeValue(loggerNode, LOGGER_ATTRIBUTE_FILE);
                if (StringUtils.isEmpty((CharSequence)LOGGER_ATTRIBUTE_FILE)) {
                    throw new ComponentDefinitionException("file attribute is missing for logger (" + kieLoggerElementParser.getId(context, element) + ")");
                }
                fileName = ExpressionUtils.resolveExpressionInPath(fileName);
                componentMetadata.addProperty(LOGGER_ATTRIBUTE_FILE, (Metadata)KieSessionElementParser.createValue(context, fileName));
                String threaded = kieLoggerElementParser.getAttributeValue(loggerNode, LOGGER_ATTRIBUTE_THREADED);
                if (!StringUtils.isEmpty((CharSequence)LOGGER_ATTRIBUTE_FILE) && "true".equalsIgnoreCase(threaded)) {
                    componentMetadata.addProperty(LOGGER_ATTRIBUTE_LOGGER_TYPE, (Metadata)KieSessionElementParser.createValue(context, KieLoggerAdaptor.KNOWLEDGE_LOGGER_TYPE.LOGGER_TYPE_THREADED_FILE.toString()));
                    String interval = kieLoggerElementParser.getAttributeValue(loggerNode, LOGGER_ATTRIBUTE_INTERVAL);
                    if (!StringUtils.isEmpty((CharSequence)interval)) {
                        try {
                            int nInterval = Integer.parseInt(interval);
                            componentMetadata.addProperty(LOGGER_ATTRIBUTE_INTERVAL, (Metadata)KieSessionElementParser.createValue(context, nInterval));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)LOGGER_ATTRIBUTE_FILE)) {
                        throw new ComponentDefinitionException("file attribute is missing for logger (" + kieLoggerElementParser.getId(context, element) + ")");
                    }
                } else {
                    componentMetadata.addProperty(LOGGER_ATTRIBUTE_LOGGER_TYPE, (Metadata)KieSessionElementParser.createValue(context, KieLoggerAdaptor.KNOWLEDGE_LOGGER_TYPE.LOGGER_TYPE_FILE.toString()));
                }
                RefMetadataImpl refMetadata = (RefMetadataImpl)context.createMetadata(RefMetadataImpl.class);
                refMetadata.setComponentId(componentMetadata.getId());
                collectionMetadata.addValue((Metadata)refMetadata);
            }
        }
        return collectionMetadata;
    }
}

