/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.factorybeans;

import java.util.HashMap;
import java.util.List;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.persistence.jpa.KnowledgeStoreServiceImpl;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.kie.api.builder.ReleaseId;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.aries.blueprint.factorybeans.KBaseOptions;
import org.kie.aries.blueprint.factorybeans.KSessionOptions;
import org.kie.aries.blueprint.factorybeans.KieBaseResolver;
import org.kie.aries.blueprint.factorybeans.KieContainerResolver;
import org.kie.aries.blueprint.factorybeans.KieListenerAdaptor;
import org.kie.aries.blueprint.factorybeans.KieLoggerAdaptor;
import org.kie.aries.blueprint.factorybeans.KieSessionRefResolver;
import org.kie.aries.blueprint.factorybeans.KieSessionResolver;
import org.kie.aries.blueprint.helpers.JPAPlaceholderResolverStrategyHelper;

public class KieObjectsFactoryBean {
    public static Object fetchKBase(String id, ReleaseId releaseId, KBaseOptions kbaseOptions) {
        return new KieBaseResolver(releaseId, id);
    }

    public static Object fetchKContainer(ReleaseId releaseId) {
        return new KieContainerResolver(releaseId);
    }

    public static Object createKieSessionRef(String id, ReleaseId releaseId, List<KieListenerAdaptor> listeners, List<KieLoggerAdaptor> loggers, List<?> commands) {
        return new KieSessionRefResolver(releaseId, id, listeners, loggers, commands);
    }

    public static Object createKieSession(String id, ReleaseId releaseId, List<KieListenerAdaptor> listeners, List<KieLoggerAdaptor> loggers, List<?> commands, KSessionOptions kSessionOptions) {
        return new KieSessionResolver(releaseId, listeners, loggers, commands, kSessionOptions);
    }

    public static KieStoreServices createKieStore() throws Exception {
        return new KnowledgeStoreServiceImpl();
    }

    public static ReleaseId createReleaseId(String id, String groupId, String artifactId, String version) {
        return new ReleaseIdImpl(groupId, artifactId, version);
    }

    public static Environment createEnvironment(String id, HashMap<String, Object> parameters, List<Object> marshallingStrategies) {
        Environment environment = EnvironmentFactory.newEnvironment();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                environment.set(key, parameters.get(key));
            }
        }
        for (int i = 0; i < marshallingStrategies.size(); ++i) {
            Object object = marshallingStrategies.get(i);
            if (!(object instanceof JPAPlaceholderResolverStrategyHelper)) continue;
            Environment refEnv = ((JPAPlaceholderResolverStrategyHelper)object).getEnvironment();
            JPAPlaceholderResolverStrategy jpaPlaceholderResolverStrategy = refEnv == null ? new JPAPlaceholderResolverStrategy(environment) : new JPAPlaceholderResolverStrategy(refEnv);
            marshallingStrategies.set(i, jpaPlaceholderResolverStrategy);
            break;
        }
        if (marshallingStrategies != null) {
            environment.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)marshallingStrategies.toArray(new ObjectMarshallingStrategy[0]));
        }
        return environment;
    }

    public static ClassObjectMarshallingStrategyAcceptor createDefaultAcceptor() {
        return ClassObjectMarshallingStrategyAcceptor.DEFAULT;
    }
}

