/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.namespace;

import java.util.ArrayList;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.FireUntilHaltCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.util.StringUtils;
import org.kie.aries.blueprint.namespace.KieSessionElementParser;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class KieSessionBatchElementParser {
    public static final String LOGGER_ATTRIBUTE_FILE = "file";
    public static final String LOGGER_ATTRIBUTE_ID = "id";
    public static final String LOGGER_ATTRIBUTE_THREADED = "threaded";
    public static final String LOGGER_ATTRIBUTE_LOGGER_TYPE = "loggerType";
    public static final String LOGGER_ATTRIBUTE_INTERVAL = "interval";

    KieSessionBatchElementParser() {
    }

    public static MutableCollectionMetadata parseBatchElement(KieSessionElementParser kieSessionElementParser, ParserContext context, Element element) {
        MutableCollectionMetadata collectionMetadata = (MutableCollectionMetadata)context.createMetadata(MutableCollectionMetadata.class);
        collectionMetadata.setCollectionClass(ArrayList.class);
        String prefix = element.getPrefix();
        NodeList batchNodeList = element.getElementsByTagName(prefix + ":batch");
        if (batchNodeList != null && batchNodeList.getLength() > 0) {
            Node batchNode = batchNodeList.item(0);
            for (int i = 0; i < batchNode.getChildNodes().getLength(); ++i) {
                String ref;
                Node n = batchNode.getChildNodes().item(i);
                if (!(n instanceof Element)) continue;
                Element e = (Element)n;
                MutableBeanMetadata componentMetadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
                if ("insert-object".equals(e.getLocalName())) {
                    ref = e.getAttribute("ref");
                    if (StringUtils.isEmpty((CharSequence)ref)) {
                        throw new ComponentDefinitionException("'ref' attribute is missing for insert-object for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                    }
                    componentMetadata.setClassName(InsertObjectCommand.class.getName());
                    componentMetadata.addArgument((Metadata)KieSessionElementParser.createRef(context, ref), null, 0);
                } else if ("set-global".equals(e.getLocalName())) {
                    ref = e.getAttribute("ref");
                    if (StringUtils.isEmpty((CharSequence)ref)) {
                        throw new ComponentDefinitionException("'ref' attribute is missing for set-global for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                    }
                    String identifier = e.getAttribute("identifier");
                    if (StringUtils.isEmpty((CharSequence)identifier)) {
                        throw new ComponentDefinitionException("'identifier' attribute is missing for set-global for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                    }
                    componentMetadata.setClassName(SetGlobalCommand.class.getName());
                    componentMetadata.addArgument((Metadata)KieSessionElementParser.createValue(context, identifier), null, 0);
                    componentMetadata.addArgument((Metadata)KieSessionElementParser.createRef(context, ref), null, 1);
                } else if ("fire-until-halt".equals(e.getLocalName())) {
                    componentMetadata.setClassName(FireUntilHaltCommand.class.getName());
                } else if ("fire-all-rules".equals(e.getLocalName())) {
                    componentMetadata.setClassName(FireAllRulesCommand.class.getName());
                    String max = e.getAttribute("max");
                    if (!StringUtils.isEmpty((CharSequence)max)) {
                        try {
                            componentMetadata.addArgument((Metadata)KieSessionElementParser.createValue(context, Integer.parseInt(max)), null, 0);
                        }
                        catch (NumberFormatException identifier) {}
                    }
                } else if (!"start-process".equals(e.getLocalName())) {
                    if ("signal-event".equals(e.getLocalName())) {
                        String ref2;
                        componentMetadata.setClassName(SignalEventCommand.class.getName());
                        String processInstanceId = e.getAttribute("process-instance-id");
                        int index = 0;
                        if (!StringUtils.isEmpty((CharSequence)processInstanceId)) {
                            try {
                                componentMetadata.addArgument((Metadata)KieSessionElementParser.createValue(context, Integer.parseInt(processInstanceId)), null, 0);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            ++index;
                        }
                        if (StringUtils.isEmpty((CharSequence)(ref2 = e.getAttribute("ref")))) {
                            throw new ComponentDefinitionException("'ref' attribute is missing for signal-event for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                        }
                        String eventType = e.getAttribute("event-type");
                        if (StringUtils.isEmpty((CharSequence)eventType)) {
                            throw new ComponentDefinitionException("'event-type' attribute is missing for signal-event for bean definition (" + kieSessionElementParser.getId(context, element) + ")");
                        }
                        componentMetadata.addArgument((Metadata)KieSessionElementParser.createValue(context, ref2), null, index++);
                        componentMetadata.addArgument((Metadata)KieSessionElementParser.createValue(context, eventType), null, index++);
                    } else {
                        throw new ComponentDefinitionException("Unknown child element found in batch element.");
                    }
                }
                collectionMetadata.addValue((Metadata)componentMetadata);
            }
        }
        return collectionMetadata;
    }

    private static Element getFirstElement(NodeList list) {
        int lengthj = list.getLength();
        for (int j = 0; j < lengthj; ++j) {
            if (!(list.item(j) instanceof Element)) continue;
            return (Element)list.item(j);
        }
        return null;
    }
}

