/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.component;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.DataFormat;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.runtime.CommandExecutor;
import org.kie.camel.embedded.component.KieComponent;
import org.kie.camel.embedded.component.KieConsumer;
import org.kie.camel.embedded.component.KieExecuteProducer;
import org.kie.camel.embedded.component.KieInsertProducer;

public class KieEmbeddedEndpoint
extends DefaultEndpoint {
    private static final String NO_KSESSION_ENDPOINT = "dynamic";
    public static final Pattern P = Pattern.compile("[\"']?lookup[\"']?\\s*[:=]\\s*[\"']([^\"']+)[\"']");
    private String ksessionId;
    private CommandExecutor executor;
    private Map<String, CommandExecutor> executorsByName;
    private String dataFormatName;
    private DataFormat dataFormat;
    private Action action = Action.EXECUTE;
    private String entryPoint = null;
    private String channel = null;

    public KieEmbeddedEndpoint(String endpointUri, String remaining, KieComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.configure(component, remaining);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new KieConsumer((Endpoint)this, processor);
    }

    public Producer createProducer() throws Exception {
        if (Action.EXECUTE.equals((Object)this.action)) {
            return new KieExecuteProducer((Endpoint)this);
        }
        return new KieInsertProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public String getKsessionId() {
        return this.ksessionId;
    }

    public void setKsessionId(String ksession) {
        this.ksessionId = ksession;
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    protected void configure(KieComponent component, String uri) {
        this.ksessionId = KieEmbeddedEndpoint.getKsessionId(uri);
        if (!StringUtils.isEmpty((CharSequence)this.ksessionId)) {
            this.executor = (CommandExecutor)component.getCamelContext().getRegistry().lookup(this.ksessionId, CommandExecutor.class);
            if (this.executor == null) {
                if (NO_KSESSION_ENDPOINT.equals(this.ksessionId)) {
                    this.executorsByName = new HashMap<String, CommandExecutor>();
                } else {
                    throw new RuntimeCamelException("Failed to instantiate KieEmbeddedEndpoint. Could not find ksession for  uri=\"" + uri + "\". Check configuration.");
                }
            }
        }
    }

    public static final String getKsessionId(String uri) {
        int pos = uri.indexOf(47);
        return pos < 0 ? uri : uri.substring(pos + 1);
    }

    public String getDataFormat() {
        return this.dataFormatName;
    }

    public void setDataFormat(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public String getLookup(String body) {
        Matcher m = P.matcher(body);
        String name = null;
        if (m.find()) {
            name = m.group(1);
        }
        return name;
    }

    public CommandExecutor getCommandExecutor(String name) {
        if (this.executorsByName == null) {
            if (this.executor == null) {
                throw new RuntimeException("ExecutionNode for CommandExecutor lookup cannot be null");
            }
            return this.executor;
        }
        CommandExecutor exec = this.executorsByName.get(name);
        if (exec == null) {
            exec = (CommandExecutor)this.getComponent().getCamelContext().getRegistry().lookup(name, CommandExecutor.class);
            if (exec == null) {
                throw new RuntimeException("ExecutionNode for CommandExecutor lookup cannot be null");
            }
            this.executorsByName.put(name, exec);
        }
        return exec;
    }

    public ClassLoader getClassLoader(CommandExecutor exec) {
        ClassLoader cl = null;
        if (exec instanceof StatefulKnowledgeSessionImpl) {
            cl = ((StatefulKnowledgeSessionImpl)exec).getKnowledgeBase().getRootClassLoader();
        } else if (exec instanceof StatelessKnowledgeSessionImpl) {
            cl = ((StatelessKnowledgeSessionImpl)exec).getKnowledgeBase().getRootClassLoader();
        } else if (exec instanceof CommandBasedStatefulKnowledgeSession) {
            cl = ((InternalKnowledgeBase)((CommandBasedStatefulKnowledgeSession)exec).getKieBase()).getRootClassLoader();
        }
        return cl;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setAction(String action) {
        this.action = Action.resolveAction(action);
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Exchange createExchange(Object pojo) {
        DefaultMessage msg = new DefaultMessage();
        msg.setBody(pojo);
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, this.getExchangePattern());
        exchange.setIn((Message)msg);
        return exchange;
    }

    public static enum Action {
        EXECUTE("execute"),
        INSERT_BODY("insertBody"),
        INSERT_MESSAGE("insertMessage"),
        INSERT_EXCHANGE("insertExchange");

        private final String id;

        private Action(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Action resolveAction(String id) {
            if (EXECUTE.getId().equalsIgnoreCase(id)) {
                return EXECUTE;
            }
            if (INSERT_BODY.getId().equalsIgnoreCase(id)) {
                return INSERT_BODY;
            }
            if (INSERT_MESSAGE.getId().equalsIgnoreCase(id)) {
                return INSERT_MESSAGE;
            }
            if (INSERT_EXCHANGE.getId().equalsIgnoreCase(id)) {
                return INSERT_EXCHANGE;
            }
            throw new IllegalArgumentException("Invalid action configuring EndPoint = " + id);
        }
    }
}

