/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.component;

import java.util.Collections;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultProducer;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.command.Command;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.ExecutionResults;
import org.kie.camel.embedded.component.ExecutionNodePipelineContextImpl;
import org.kie.camel.embedded.component.KieEmbeddedEndpoint;

public class KieExecuteProducer
extends DefaultProducer {
    public KieExecuteProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        CommandExecutor exec;
        ExecutionNodePipelineContextImpl droolsContext;
        KieEmbeddedEndpoint ke = (KieEmbeddedEndpoint)this.getEndpoint();
        Command cmd = (Command)exchange.getIn().getBody(ExecutableCommand.class);
        if (cmd == null) {
            throw new RuntimeCamelException("Body of in message not of the expected type 'org.kie.api.command.Command' for uri" + ke.getEndpointUri());
        }
        if (!(cmd instanceof BatchExecutionCommandImpl)) {
            cmd = new BatchExecutionCommandImpl(Collections.singletonList(cmd));
        }
        if ((droolsContext = (ExecutionNodePipelineContextImpl)exchange.getProperty("kie-context", ExecutionNodePipelineContextImpl.class)) != null) {
            exec = droolsContext.getCommandExecutor();
        } else {
            exec = ke.getExecutor();
            if (exec == null) {
                String lookup = (String)exchange.getIn().getHeader("KieLookup", String.class);
                if (StringUtils.isEmpty((CharSequence)lookup) && cmd instanceof BatchExecutionCommandImpl) {
                    lookup = ((BatchExecutionCommandImpl)cmd).getLookup();
                }
                if (!StringUtils.isEmpty((CharSequence)lookup)) {
                    exec = (CommandExecutor)ke.getComponent().getCamelContext().getRegistry().lookup(lookup, CommandExecutor.class);
                    if (exec == null) {
                        throw new RuntimeException("ExecutionNode is unable to find ksession=" + lookup + " for uri" + ke.getEndpointUri());
                    }
                } else {
                    throw new RuntimeException("No ExecutionNode, unable to find ksession=" + lookup + " for uri" + ke.getEndpointUri());
                }
            }
        }
        if (exec == null) {
            throw new RuntimeException("No defined ksession for uri " + ke.getEndpointUri());
        }
        ExecutionResults results = (ExecutionResults)exec.execute((Command)((BatchExecutionCommandImpl)cmd));
        exchange.getIn().setBody((Object)results);
    }
}

