/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.kie.builder.ReleaseId;
import org.kie.scanner.DependencyDescriptor;
import org.kie.scanner.MavenRepository;
import org.kie.scanner.PomParser;
import org.kie.scanner.embedder.EmbeddedPomParser;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.sonatype.aether.artifact.Artifact;

class ArtifactResolver {
    private final PomParser pomParser;
    private final MavenRepository mavenRepository;

    ArtifactResolver() {
        this.mavenRepository = MavenRepository.getMavenRepository();
        this.pomParser = new EmbeddedPomParser();
    }

    private ArtifactResolver(MavenProject mavenProject) {
        this.mavenRepository = MavenRepository.getMavenRepository(mavenProject);
        this.pomParser = new EmbeddedPomParser(mavenProject);
    }

    Artifact resolveArtifact(String artifactName) {
        return this.mavenRepository.resolveArtifact(artifactName);
    }

    List<DependencyDescriptor> getArtifactDependecies(String artifactName) {
        return this.mavenRepository.getArtifactDependecies(artifactName);
    }

    List<DependencyDescriptor> getPomDirectDependencies() {
        return this.pomParser.getPomDirectDependencies();
    }

    Collection<DependencyDescriptor> getAllDependecies() {
        HashSet<DependencyDescriptor> dependencies = new HashSet<DependencyDescriptor>();
        for (DependencyDescriptor dep : this.getPomDirectDependencies()) {
            dependencies.add(dep);
            dependencies.addAll(this.getArtifactDependecies(dep.toString()));
        }
        return dependencies;
    }

    public static ArtifactResolver getResolverFor(ReleaseId releaseId, boolean allowDefaultPom) {
        MavenProject mavenProject = ArtifactResolver.getMavenProjectForGAV(releaseId);
        return mavenProject == null ? (allowDefaultPom ? new ArtifactResolver() : null) : new ArtifactResolver(mavenProject);
    }

    public static ArtifactResolver getResolverFor(URI uri) {
        return ArtifactResolver.getResolverFor(new File(uri));
    }

    public static ArtifactResolver getResolverFor(File pomFile) {
        MavenProject mavenProject = MavenProjectLoader.parseMavenPom(pomFile);
        return new ArtifactResolver(mavenProject);
    }

    public static ArtifactResolver getResolverFor(InputStream pomStream) {
        MavenProject mavenProject = MavenProjectLoader.parseMavenPom(pomStream);
        return new ArtifactResolver(mavenProject);
    }

    static MavenProject getMavenProjectForGAV(ReleaseId releaseId) {
        String artifactName = releaseId.getGroupId() + ":" + releaseId.getArtifactId() + ":pom:" + releaseId.getVersion();
        Artifact artifact = MavenRepository.getMavenRepository().resolveArtifact(artifactName);
        return artifact != null ? MavenProjectLoader.parseMavenPom(artifact.getFile()) : null;
    }
}

