/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.drools.kproject.ReleaseIdImpl;
import org.kie.builder.ReleaseId;
import org.sonatype.aether.artifact.Artifact;

public class DependencyDescriptor {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final ArtifactVersion artifactVersion;

    public DependencyDescriptor(Dependency dependency) {
        this.groupId = dependency.getGroupId();
        this.artifactId = dependency.getArtifactId();
        this.version = dependency.getVersion();
        this.type = dependency.getType();
        this.artifactVersion = new DefaultArtifactVersion(this.version);
    }

    public DependencyDescriptor(Artifact artifact) {
        this.groupId = artifact.getGroupId();
        this.artifactId = artifact.getArtifactId();
        this.version = artifact.isSnapshot() ? artifact.getBaseVersion() : artifact.getVersion();
        this.type = artifact.getExtension();
        this.artifactVersion = new DefaultArtifactVersion(artifact.getVersion());
    }

    public DependencyDescriptor(String groupId, String artifactId, String version, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.artifactVersion = new DefaultArtifactVersion(version);
    }

    public DependencyDescriptor(ReleaseId releaseId) {
        this.groupId = releaseId.getGroupId();
        this.artifactId = releaseId.getArtifactId();
        this.version = releaseId.getVersion();
        this.type = "jar";
        this.artifactVersion = new DefaultArtifactVersion(this.version);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public ReleaseId getGav() {
        return new ReleaseIdImpl(this.groupId, this.artifactId, this.version);
    }

    public String getType() {
        return this.type;
    }

    public boolean isFixedVersion() {
        return !this.isSnapshot() && !this.version.equals("LATEST") && !this.version.equals("RELEASE");
    }

    public boolean isSnapshot() {
        return this.version.endsWith("SNAPSHOT");
    }

    public boolean isValid() {
        return this.version != null;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toResolvableString() {
        return this.isSnapshot() ? this.toString() : this.groupId + ":" + this.artifactId + ":LATEST";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyDescriptor that = (DependencyDescriptor)o;
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public boolean isNewerThan(DependencyDescriptor o) {
        return this.artifactVersion.compareTo((Object)o.artifactVersion) > 0;
    }
}

