/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.utils.ClassLoaderResolver;
import org.kie.scanner.ArtifactResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;

public class MavenClassLoaderResolver
implements ClassLoaderResolver {
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final Logger logger;

    public ClassLoader getClassLoader(KieModule kmodule) {
        InternalKieModule internalKModule;
        Collection jarDependencies;
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if (parent == null) {
            parent = MavenClassLoaderResolver.class.getClassLoader();
        }
        if ((jarDependencies = (internalKModule = (InternalKieModule)kmodule).getJarDependencies()).isEmpty()) {
            return parent;
        }
        ArtifactResolver resolver = ArtifactResolver.getResolverFor(kmodule.getReleaseId(), true);
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<ReleaseId> unresolvedDeps = new ArrayList<ReleaseId>();
        for (ReleaseId rid : jarDependencies) {
            try {
                Artifact artifact = resolver.resolveArtifact(rid);
                if (artifact != null) {
                    File jar = artifact.getFile();
                    urls.add(jar.toURI().toURL());
                    continue;
                }
                logger.error("Dependency artifact not found for: " + rid);
                unresolvedDeps.add(rid);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        internalKModule.setUnresolvedDependencies(unresolvedDeps);
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    static {
        logger = LoggerFactory.getLogger(MavenClassLoaderResolver.class);
        PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MavenClassLoaderResolver.class.getProtectionDomain();
            }
        });
    }
}

