/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.compiler.kproject.xml.DependencyFilter;
import org.drools.core.factmodel.ClassBuilderFactory;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.MavenRepository;

public class KieModuleMavenTest
extends AbstractKieCiTest {
    @Test
    public void testKieModuleFromMavenNoDependencies() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, true, "rule1", "rule2");
        String pomText = this.getPom(releaseId, null);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MavenRepository.getMavenRepository().deployArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBaseModel kbaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
        Assert.assertNotNull((String)"Default kbase was not found", (Object)kbaseModel);
        String kbaseName = kbaseModel.getName();
        Assert.assertEquals((Object)"KBase1", (Object)kbaseName);
    }

    @Test
    public void testKieModuleFromMavenWithDependencies() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, true, "rule1", "rule2");
        String pomText = this.getPom(releaseId, dependency);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MavenRepository.getMavenRepository().deployArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBaseModel kbaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
        Assert.assertNotNull((String)"Default kbase was not found", (Object)kbaseModel);
        String kbaseName = kbaseModel.getName();
        Assert.assertEquals((Object)"KBase1", (Object)kbaseName);
    }

    @Test
    public void testKieModuleFromMavenWithTransitiveDependencies() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test", "1.0-SNAPSHOT");
        String pomText = this.getPom(releaseId, dependency);
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, pomText, true, "rule1", "rule2");
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MavenRepository.getMavenRepository().deployArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        HashSet<ReleaseId> expectedDependencies = new HashSet<ReleaseId>();
        expectedDependencies.add(ks.newReleaseId("org.drools", "knowledge-api", "5.5.0.Final"));
        expectedDependencies.add(ks.newReleaseId("org.drools", "knowledge-internal-api", "5.5.0.Final"));
        expectedDependencies.add(ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final"));
        expectedDependencies.add(ks.newReleaseId("org.mvel", "mvel2", "2.1.3.Final"));
        expectedDependencies.add(ks.newReleaseId("org.slf4j", "slf4j-api", "1.6.4"));
        Collection dependencies = ((InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase("KBase1")).getJarDependencies(DependencyFilter.TAKE_ALL_FILTER);
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)5L, (long)dependencies.size());
        boolean matchedAll = dependencies.containsAll(expectedDependencies);
        Assert.assertTrue((boolean)matchedAll);
    }

    @Test
    public void testKieModulePojoDependencies() throws Exception {
        KieServices ks = KieServices.Factory.get();
        String pojoNS = "org.kie.pojos";
        ReleaseId pojoID = KieServices.Factory.get().newReleaseId(pojoNS, "pojojar", "2.0.0");
        String className = "Message";
        ClassDefinition def = new ClassDefinition(pojoNS + "." + className);
        def.addField(new FieldDefinition("text", String.class.getName()));
        byte[] messageClazz = ClassBuilderFactory.getDefaultBeanClassBuilder().buildClass(def, null);
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.write(pojoNS.replace('.', '/') + "/" + className + ".class", messageClazz);
        byte[] pomContent = KieModuleMavenTest.generatePomXml(pojoID, new ReleaseId[0]).getBytes();
        mfs.write("META-INF/maven/" + pojoID.getGroupId() + "/" + pojoID.getArtifactId() + "/pom.xml", pomContent);
        mfs.write("META-INF/maven/" + pojoID.getGroupId() + "/" + pojoID.getArtifactId() + "/pom.properties", KieModuleMavenTest.generatePomProperties(pojoID).getBytes());
        byte[] pojojar = mfs.writeAsBytes();
        MavenRepository.getMavenRepository().deployArtifact(pojoID, pojojar, pomContent);
        String kjarNS = "org.kie.test1";
        ReleaseId kjarID = KieServices.Factory.get().newReleaseId(kjarNS, "rkjar", "1.0.0");
        String rule = this.getRule(kjarNS, pojoNS, "R1");
        String pom = KieModuleMavenTest.generatePomXml(kjarID, pojoID);
        byte[] rkjar = KieModuleMavenTest.createKJar(ks, kjarID, pom, rule);
        KieModule kmodule = KieModuleMavenTest.deployJar(ks, rkjar);
        Assert.assertNotNull((Object)kmodule);
        KieContainer kContainer = ks.newKieContainer(kjarID);
        KieSession kSession = kContainer.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testKieContainerBeforeAndAfterDeployOfSnapshot() throws Exception {
        KieServices ks = KieServices.Factory.get();
        String group = "org.kie.test";
        String artifact = "test-module";
        String version = "1.0.0-SNAPSHOT";
        ReleaseId releaseId = ks.newReleaseId(group, artifact, version);
        String prefix = new File(".").getAbsolutePath().contains("kie-ci") ? "" : "kie-ci/";
        File kjar = new File(prefix + "src/test/resources/kjar/kjar-module-before.jar");
        File pom = new File(prefix + "src/test/resources/kjar/pom-kjar.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kjar, pom);
        KieContainer kContainer = ks.newKieContainer(releaseId);
        KieBase kbase = kContainer.getKieBase();
        Assert.assertNotNull((Object)kbase);
        Collection packages = kbase.getKiePackages();
        Assert.assertNotNull((Object)packages);
        Assert.assertEquals((long)1L, (long)packages.size());
        Collection rules = ((KiePackage)packages.iterator().next()).getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        ks.getRepository().removeKieModule(releaseId);
        File kjar1 = new File(prefix + "src/test/resources/kjar/kjar-module-after.jar");
        File pom1 = new File(prefix + "src/test/resources/kjar/pom-kjar.xml");
        repository.deployArtifact(releaseId, kjar1, pom1);
        KieContainer kContainer2 = ks.newKieContainer(releaseId);
        KieBase kbase2 = kContainer2.getKieBase();
        Assert.assertNotNull((Object)kbase2);
        Collection packages2 = kbase2.getKiePackages();
        Assert.assertNotNull((Object)packages2);
        Assert.assertEquals((long)1L, (long)packages2.size());
        Collection rules2 = ((KiePackage)packages2.iterator().next()).getRules();
        Assert.assertEquals((long)4L, (long)rules2.size());
        ks.getRepository().removeKieModule(releaseId);
    }

    @Test
    public void testKieModuleFromMavenWithDependenciesProperties() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "${version.org.drools}");
        ReleaseId releaseId = ks.newReleaseId("org.kie.test", "maven-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJarWithProperties((KieServices)ks, releaseId, true, "5.5.0.Final", new ReleaseId[]{dependency}, "rule1", "rule2");
        String pomText = KieModuleMavenTest.generatePomXmlWithProperties(releaseId, "5.5.0.Final", dependency);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MavenRepository.getMavenRepository().deployArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBaseModel kbaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
        Assert.assertNotNull((String)"Default kbase was not found", (Object)kbaseModel);
        String kbaseName = kbaseModel.getName();
        Assert.assertEquals((Object)"KBase1", (Object)kbaseName);
    }

    public static String generatePomXml(ReleaseId releaseId, ReleaseId ... dependencies) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append("         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append("    <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append("    <groupId>").append(releaseId.getGroupId()).append("</groupId> \n");
        sBuilder.append("    <artifactId>").append(releaseId.getArtifactId()).append("</artifactId> \n");
        sBuilder.append("    <version>").append(releaseId.getVersion()).append("</version> \n");
        sBuilder.append("    <packaging>jar</packaging> \n");
        sBuilder.append("    <name>Default</name> \n");
        if (dependencies.length > 0) {
            sBuilder.append("<dependencies>\n");
            for (ReleaseId dep : dependencies) {
                sBuilder.append("  <dependency>\n");
                sBuilder.append("    <groupId>").append(dep.getGroupId()).append("</groupId> \n");
                sBuilder.append("    <artifactId>").append(dep.getArtifactId()).append("</artifactId> \n");
                sBuilder.append("    <version>").append(dep.getVersion()).append("</version> \n");
                sBuilder.append("  </dependency>\n");
            }
            sBuilder.append("</dependencies>\n");
        }
        sBuilder.append("</project>  \n");
        return sBuilder.toString();
    }

    public static String generatePomXmlWithProperties(ReleaseId releaseId, String droolsVersion, ReleaseId ... dependencies) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append(" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append(" <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append(" <groupId>").append(releaseId.getGroupId()).append("</groupId> \n");
        sBuilder.append(" <artifactId>").append(releaseId.getArtifactId()).append("</artifactId> \n");
        sBuilder.append(" <version>").append(releaseId.getVersion()).append("</version> \n");
        sBuilder.append(" <packaging>jar</packaging> \n");
        sBuilder.append(" <name>Default</name> \n");
        sBuilder.append(" <properties> \n");
        sBuilder.append(" <version.org.drools>" + droolsVersion + "</version.org.drools> \n");
        sBuilder.append(" </properties> \n");
        if (dependencies.length > 0) {
            sBuilder.append("<dependencies>\n");
            for (ReleaseId dep : dependencies) {
                sBuilder.append(" <dependency>\n");
                sBuilder.append(" <groupId>").append(dep.getGroupId()).append("</groupId> \n");
                sBuilder.append(" <artifactId>").append(dep.getArtifactId()).append("</artifactId> \n");
                sBuilder.append(" <version>").append(dep.getVersion()).append("</version> \n");
                sBuilder.append(" </dependency>\n");
            }
            sBuilder.append("</dependencies>\n");
        }
        sBuilder.append("</project> \n");
        return sBuilder.toString();
    }

    protected InternalKieModule createKieJarWithProperties(KieServices ks, ReleaseId releaseId, boolean isdefault, String droolsVersion, ReleaseId[] dependencies, String ... rules) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, isdefault);
        kfs.writePomXML(KieModuleMavenTest.generatePomXmlWithProperties(releaseId, droolsVersion, dependencies));
        for (String rule : rules) {
            String file = "org/test/" + rule + ".drl";
            kfs.write("src/main/resources/KBase1/" + file, this.createDRL(rule));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    public static String generatePomProperties(ReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("version=").append(releaseId.getVersion()).append("\n");
        sBuilder.append("groupId=").append(releaseId.getGroupId()).append("\n");
        sBuilder.append("artifactId=").append(releaseId.getArtifactId()).append("\n");
        return sBuilder.toString();
    }

    public String getRule(String namespace, String messageNS, String ruleName) {
        String s = "package " + namespace + "\n" + "import " + messageNS + ".Message\n" + "global java.util.List list\n" + "rule " + ruleName + " when \n" + "then \n" + "  Message msg = new Message('hello');\n" + "  list.add(msg);\n " + "end \n" + "";
        return s;
    }
}

